package csbase.client.applications.commandsmonitor.table.column;

import java.util.Locale;

import csbase.logic.CommandInfo;
import csbase.logic.applicationservice.ApplicationRegistry;

public class AttemptsColumn extends AbstractCommandsTableColumn {

  /**
   * Construtor.
   *
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public AttemptsColumn(String id, ApplicationRegistry appRegistry) {
    super(String.class, id, appRegistry);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    try {
      int retries = cmd.getSubmissionAttempts();
      if (retries < 0) {
        return getDefaultErrorValue();
      }
      return retries;
    }
    catch (Exception e) {
      return getDefaultErrorValue();
    }
  }
}
