/*
 * $Id: CommonExchangeAction.java 150777 2014-03-19 14:16:56Z oikawa $
 */

package csbase.client.project.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.lng.LNG;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileContainer;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;

/**
 * Ao generica de troca de arquivos.
 * 
 * @author Tecgraf/PUC-Rio
 */
abstract class CommonExchangeAction extends CommonProjectAction {

  /**
   * Identificador default da aplicao <code> {@link FileExchanger} </code>
   */
  private final String DEFAULT_APP_ID = "fileexchanger";

  /**
   * Tag da proprieadede do configuration manager que define o identificador da
   * aplicao {@link FileExchanger}, que ser lanada nesta ao.
   */
  private final String APP_ID_PROP_NAME = "file.exchanger.application.id";

  /**
   * Cria/Retorna uma aplicao
   * 
   * @return a aplicao
   */
  final protected FileExchanger getFileExchanger() {
    try {
      final ConfigurationManager cnfMng = ConfigurationManager.getInstance();
      final Configuration cnf = cnfMng.getConfiguration(this.getClass());
      final String id =
        cnf.getOptionalProperty(APP_ID_PROP_NAME, DEFAULT_APP_ID);

      final ApplicationManager appMng = ApplicationManager.getInstance();
      final Vector<ApplicationType> runs = appMng.getRunningApplications(id);
      final FileExchanger fe;
      if (runs != null && runs.size() > 0) {
        fe = (FileExchanger) runs.get(0);
      }
      else {
        fe = (FileExchanger) appMng.runApplication(id);
      }
      return fe;
    }
    catch (final Exception e) {
      final DesktopFrame desktopFrame = DesktopFrame.getInstance();
      final DesktopComponentFrame frame = desktopFrame.getDesktopFrame();
      StandardErrorDialogs.showErrorDialog(frame, getName(), "", e);
      return null;
    }
  }

  /**
   * Verifica se aplicao fileexchanger est executando.
   * 
   * @return se aplicao fileexchanger est executando.
   */
  final synchronized protected boolean isFileExchangerRunning() {
    boolean result = false;
    try {
      final ConfigurationManager cnfMng = ConfigurationManager.getInstance();
      final Configuration cnf = cnfMng.getConfiguration(this.getClass());
      final String id =
        cnf.getOptionalProperty(APP_ID_PROP_NAME, DEFAULT_APP_ID);

      final ApplicationManager appMng = ApplicationManager.getInstance();
      final Vector<ApplicationType> runs = appMng.getRunningApplications(id);
      if (runs != null && runs.size() > 0) {
        result = true;
      }
    }
    catch (final Exception e) {
      final DesktopFrame desktopFrame = DesktopFrame.getInstance();
      final DesktopComponentFrame frame = desktopFrame.getDesktopFrame();
      StandardErrorDialogs.showErrorDialog(frame, getName(), "", e);
    }
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String getName() {
    return getString("name");
  }

  /**
   * Consulta o arquivo selecionado.
   * 
   * @return o arquivo.
   */
  final protected ClientProjectFile getSelectedRemoteFile() {
    final ClientProjectFile file = getSelectedFile();
    return file;
  }

  /**
   * Consulta os arquivos selecionados.
   * 
   * @return a lista de arquivos.
   */
  final protected List<ClientProjectFile> getSelectedRemoteFiles() {
    final ClientProjectFile[] files = getSelectedFiles();
    final ArrayList<ClientProjectFile> list =
      new ArrayList<ClientProjectFile>();
    for (final ClientProjectFile file : files) {
      list.add(file);
    }
    return list;
  }

  /**
   * Monta um texto de internacionalizao.
   * 
   * @param tag o tag
   * @return o texto
   */
  final protected String getString(final String tag) {
    final String className = getClass().getSimpleName();
    return LNG.get(className + "." + tag);
  }

  /**
   * Construtor
   * 
   * @param container o container de projetos
   * 
   */
  public CommonExchangeAction(final ProjectFileContainer container) {
    super(container);
  }
}
