/*
 * $Id:$
 */
package csbase.client.util.xmlpanel.xmltextpanel;

import java.awt.BorderLayout;
import java.awt.Font;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.w3c.dom.Node;

import csbase.client.util.xmlpanel.XMLAbstractPanel;

/**
 * Panel de texto de n.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class XMLTextPanel extends XMLAbstractPanel {

  /**
   * rea de texto.
   */
  final private JTextArea textArea = new JTextArea();

  /**
   * {@inheritDoc}
   */
  @Override
  public void setNode(Node node) {
    internalSetNode(node);
    if (node == null) {
      textArea.setText(null);
      return;
    }
    final String text = node.getTextContent();
    textArea.setText(text);
    textArea.setCaretPosition(0);
  }

  /**
   * Construtor
   */
  public XMLTextPanel() {
    textArea.setEditable(false);
    final Font fnt = textArea.getFont();
    final int style = fnt.getStyle();
    final int size = fnt.getSize();
    textArea.setFont(new Font(Font.MONOSPACED, style, size));
    textArea.setBackground(this.getBackground());
    textArea.setLineWrap(true);
    final JScrollPane scrollPane = new JScrollPane(textArea);

    setLayout(new BorderLayout());
    add(scrollPane, BorderLayout.CENTER);

  }
}
