/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree;

import java.util.Set;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AddPlatform;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         N que representa o diretrio bin que detm todas as plataformas.
 */
final class ExecutableNode extends AbstractVersionTreeNode {

  private AlgorithmVersionInfo version;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm este n.
   * @param version Verso que detm este n.
   */
  public ExecutableNode(VersionTree tree, AlgorithmVersionInfo version) {
    super(tree, version.getBinDirName());

    this.version = version;

    Set<String> platforms = version.getPlatforms().keySet();
    for (String platform : platforms) {
      add(new PlatformNode(tree, version, platform));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon() {
    return ApplicationImages.ICON_FOLDER_16;
  }

  /**
   * Cria um menu pop-up para este n.
   * 
   * @return um menu pop-up para este n.
   */
  @Override
  public JPopupMenu createPopupMenu() {
    JPopupMenu popupMenu = new JPopupMenu();
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
      new AddPlatform(getTree(), version))));

    return popupMenu;
  }

}
