/**
 * $Id: ClientFileSingleTypeFilter.java 175310 2016-08-03 14:38:03Z fpina $
 */
package csbase.client.util.filechooser.filters;

import java.util.List;

import javax.swing.ImageIcon;

import csbase.client.project.ClientProjectFileType;
import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;

/**
 * Filtro com base no nipo do arquivo.
 * 
 * @author Tecgraf
 */
public class ClientFileSingleTypeFilter implements ClientFileFilterInterface {

  /**
   * Tipo.
   */
  private final String type;

  /**
   * Construtor.
   * 
   * @param type tipo do arquivo a ser filtrado.
   */
  public ClientFileSingleTypeFilter(String type) {
    this.type = type;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean accept(ClientFile file, Operation operation) {
    if (file.isDirectory() && operation == Operation.VISUALIZATION) {
      return true;
    }
    if (file.getType().equals(type)) {
      return true;
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDescription() {
    ClientProjectFileType fileType = ClientProjectFileType.getFileType(type);
    final String desc = fileType.getDescription();
    final List<String> extensions = fileType.getExtensions();
    String extSufix = "(";
    for (String ext : extensions) {
      extSufix = extSufix + " *." + ext + " ";
    }
    extSufix = extSufix + ")";
    return type + ": " + desc + " - " + extSufix;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon() {
    ClientProjectFileType fileType = ClientProjectFileType.getFileType(type);
    return fileType.getBaseIcon();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ProjectFileType inferFileType() {
    final ProjectFileType tp = ProjectFileType.getFileType(type);
    return tp;
  }
}
