package csbase.client.algorithms.commands.newview;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.kernel.ClientException;
import csbase.logic.CommandInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;

/**
 * Viso de um comando simples.
 */
class SimpleCommandView extends AbstractCommandView {

  /**
   * Construtor.
   * 
   * @param cmd o comando sendo visualizado (No aceita {@code null}).
   * @param configurator o configurador do algoritmo executado pelo comando (No
   *        aceita {@code null}).
   * 
   * @throws ClientException em caso de erro na criao da viso do comando.
   */
  public SimpleCommandView(CommandInfo cmd, AlgorithmConfigurator configurator)
    throws ClientException {
    super(CommandViewType.SIMPLE, cmd, configurator);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getTitle() {
    return LNG.get(
      SimpleCommandView.class.getSimpleName() + ".window.title",
      new Object[] { configurator.getAlgorithmName(),
          configurator.getAlgorithmVersionId() });
  }
}