/*
 * $Id: UpLocalDirectoryAction.java 116866 2011-04-01 15:13:57Z cassino $
 */

/**
 * 
 */
package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.localpanel.FileTransferClientLocalPanel;
import csbase.logic.ClientProjectFile;

/**
 * @author admin
 * 
 */
public class UpLocalDirectoryAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final FileTransferClientLocalPanel localPanel = app.getLocalPanel();
    final ClientProjectFile localDir = localPanel.getLocalDirectory();
    if (localDir.isRoot()) {
      return;
    }
    final ClientProjectFile parent = localDir.getParent();
    localPanel.setLocalDirectory(parent);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  public UpLocalDirectoryAction(final FileTransferClient application) {
    super(application);
  }
}
