package csbase.client.applications.projectsynchronization;

import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JEditorPane;
import javax.swing.JFrame;

import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationResult;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.IWizardListener;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.StepGroup;
import tecgraf.javautils.gui.wizard.Wizard;
import tecgraf.javautils.gui.wizard.Wizard.FinishingType;
import tecgraf.javautils.gui.wizard.WizardException;
import tecgraf.javautils.gui.wizard.utils.leftdecorations.FollowStepLeftDecoration;

/**
 * Aplicao de sincronizao de projetos.
 */
public class ProjectSynchronization extends Application implements
  IWizardListener {
  /** Wizard para sincronizao */
  private Wizard wizard;
  /** Etapa de concluso */
  private StepConclusion stepConclusion;
  /** Task que executa a sincronizao */
  private ProjectSynchronizationRemoteTask task;

  /**
   * Contrutor da aplicao.
   *
   * @param id identificador do projeto
   */
  public ProjectSynchronization(String id) {
    super(id);
    buildFrame();
  }

  /**
   * Constri o painel da aplicao.
   */
  private void buildFrame() {
    JFrame mainFrame = getApplicationFrame();
    String remoteServer = getStringSpecificProperty("remoteServer");
    String remotePort = getStringSpecificProperty("remotePort");
    List<StepGroup> list = new ArrayList<StepGroup>();
    StepGroup sg = new StepGroup(getString("desc.step1"));
    sg.add(new StepSelectionServers(getApplicationRegistry(), remoteServer,
      remotePort));
    list.add(sg);
    sg = new StepGroup(getString("desc.step2"));
    sg.add(new StepSelectionProjects(getApplicationRegistry()));
    list.add(sg);
    sg = new StepGroup(getString("desc.step3"));
    sg.add(new StepSelectionFilesA(getApplicationRegistry()));
    list.add(sg);
    sg = new StepGroup(getString("desc.step4"));
    sg.add(new StepSelectionFilesB(getApplicationRegistry()));
    list.add(sg);
    sg = new StepGroup(getString("desc.step5"));
    stepConclusion = new StepConclusion(getApplicationRegistry());
    sg.add(stepConclusion);
    list.add(sg);
    wizard = new Wizard(StepSelectionServers.class, list, null, null,
      FinishingType.CANCELABLE_AND_CLOSEABLE, new FollowStepLeftDecoration(
        list), false);
    wizard.addListener(this);
    mainFrame.getContentPane().add(wizard);
    mainFrame.setPreferredSize(new Dimension(900, 420));
    mainFrame.pack();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void killApplication() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean userCanKillApplication() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasCancelled(Step arg0) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasClosed(Step arg0) {
    finishApplication();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasConfirmed(Step arg0, Object obj) {
    ProjectSynchronizationData data = (ProjectSynchronizationData) obj;
    JEditorPane textArea = stepConclusion.getContainerConclusion()
      .getEConclusion();
    String text = stepConclusion.getContainerConclusion().getText();
    try {
      ProjectSynchronizationWizardMonitor monitor =
        new ProjectSynchronizationWizardMonitor(textArea, new StringBuffer(
          text), this);
      task = new ProjectSynchronizationRemoteTask(data, monitor);
      task.execute(getApplicationFrame(), getName(), getString(
        "ProjectSynchronization.synchronizing"), 0, RemoteTask.CANCEL_BUTTON,
        false, true);
      if (monitor.isCancelled()) {
        showInformation(getString("ProjectSynchronization.canceled.msg"));
      }
      else {
        ProjectSynchronizationResult result = task.getResult();
        if (result.succeeded()) {
          showInformation(getString("ProjectSynchronization.success.msg"));
        }
        else {
          Throwable cause = result.getCause();
          if (cause == null) {
            showError(getString("ProjectSynchronization.failure.msg"));
          }
          else {
            showException(result.getMessage(), result.getCause());
          }
        }
      }
    }
    catch (RemoteException e) {
      e.printStackTrace();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasGoneNext(Step arg0, History arg1) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasGonePrevious(Step arg0, History arg1) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasHappenedException(Step arg0, WizardException arg1) {
  }

  /**
   * Retorna a task responsvel pela sincronizao.
   *
   * @return a task responsvel pela sincronizao
   */
  public ProjectSynchronizationRemoteTask getTask() {
    return task;
  }
}
