/*
 * Detalhes da ltima alterao:
 * 
 * $Author: fpina $ $Date: 2016-08-03 11:38:03 -0300 (Wed, 03 Aug 2016) $
 * $Revision: 175310 $
 */
package csbase.client.externalresources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.jnlp.FileContents;

/**
 * Implementao da <code>LocalFile</code> para execues em que a API JNLP
 * esteja disponvel.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class JNLPLocalFile implements LocalFile {
  /**  a classe que representa o arquivo no sistema do cliente efetivamente. */
  private FileContents fileContents;

  /**
   * Cria um arquivo no sistema do cliente.
   * 
   * @param fileContents O arquivo propriamente dito.
   * 
   * @throws IllegalArgumentException Caso o arquivo recebido seja nulo.
   */
  JNLPLocalFile(FileContents fileContents) {
    if (fileContents == null) {
      throw new IllegalArgumentException(
        "No  permitido criar um arquivo local nulo.");
    }
    this.fileContents = fileContents;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public long getLength() throws IOException {
    return this.fileContents.getLength();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canRead() throws IOException {
    return this.fileContents.canRead();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canWrite() throws IOException {
    return this.fileContents.canWrite();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public InputStream getInputStream() throws IOException {
    return this.fileContents.getInputStream();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public OutputStream getOutputStream(boolean append) throws IOException {
    return this.fileContents.getOutputStream(append);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() throws IOException {
    return this.fileContents.getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getAbsolutePath() throws IOException {
    return this.fileContents.getName();
  }

  /**
   * Obtm o arquivo do sistema do cliente.
   * 
   * @return O arquivo do sistema do cliente.
   */
  FileContents getFileContents() {
    return this.fileContents;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean exists() {
    try {
      fileContents.getLength();
      return true;
    }
    catch (IOException e) {
      return false;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isDirectory() {
    return false;
  }
}
