package csbase.client.algorithms.tasks;

import java.util.List;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Descreve um fluxo desatualizado com os ns que precisam ser atualizados
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class OutdatedFlowInfo {
  /** Fluxo */
  private AlgorithmInfo flow;

  /** Ns desatualizados */
  private List<AlgorithmInfo> lastVersionNodes;

  /** Ns desatualizados */
  private List<AlgorithmVersionInfo> outdatedVersionNodes;

  /** Erro */
  private Exception error;

  /**
   * Constri uma informao de fluxo desatualizado
   * 
   * @param flow Fluxo
   * @param lastVersionNodes Lista dos algoritmos desatualizados
   * @param outdatedVersionNodes Lista da verso sendo usada pelo fluxo
   * @param error Erro ao buscar informao de atualizao.
   */
  public OutdatedFlowInfo(AlgorithmInfo flow, List<AlgorithmInfo> lastVersionNodes,
    List<AlgorithmVersionInfo> outdatedVersionNodes, Exception error) {
    super();
    this.flow = flow;
    this.lastVersionNodes = lastVersionNodes;
    this.outdatedVersionNodes = outdatedVersionNodes;
    this.error = error;
  }

  /**
   * Obtem o fluxo
   * 
   * @return o Fluxo
   */
  public AlgorithmInfo getFlow() {
    return flow;
  }

  /**
   * Obtm a lista de algoritmos desatualizados
   * 
   * @return lista de algoritmos desatualizados
   */
  public List<AlgorithmInfo> getLastVersionNodes() {
    return lastVersionNodes;
  }

  /**
   * Obtm a lista da verso desatualizada sendo usada para cada algoritmo
   * 
   * @return lista da verso desatualizada sendo usada para cada algoritmo
   */
  public List<AlgorithmVersionInfo> getOutdatedVersionNodes() {
    return outdatedVersionNodes;
  }

  /**
   * Erro
   * 
   * @return erro
   */
  public Exception getError() {
    return error;
  }

  /**
   * Como mostrar o elmento na lista {@inheritDoc}
   */
  @Override
  public String toString() {
    if (flow != null) {
      return flow.getName() + " (" + flow.getLastVersion() + ")";
    }
    return "";
  }
};