package csbase.client.algorithms.commands.newview;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent.Type;
import csbase.client.kernel.ClientException;
import csbase.client.util.gui.log.tab.Tab;
import csbase.logic.CommandInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;

/**
 * Viso detalhada de um comando do tipo fluxo. Apresenta los logs consolidados
 * do fluxo.
 */
class FlowDetailsView extends AbstractCommandView {

  /**
   * Aba de informaes gerais sobre o fluxo.
   */
  private FlowInfoTab flowInfoTab;

  /**
   * Construtor.
   * 
   * @param cmd o comando sendo visualizado (No aceita {@code null}).
   * @param configurator o configurador do algoritmo executado pelo comando (No
   *        aceita {@code null}).
   * 
   * @throws ClientException em caso de erro na criao da viso do comando.
   */
  public FlowDetailsView(CommandInfo cmd, FlowAlgorithmConfigurator configurator)
    throws ClientException {
    super(CommandViewType.FLOW, cmd, configurator);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Tab createDetailsTab() throws ClientException {
    if (flowInfoTab == null) {
      String key = FlowDetailsView.class.getSimpleName() + ".tab.info.title";
      String title = LNG.get(key);
      FlowAlgorithmConfigurator flowConfigurator =
        (FlowAlgorithmConfigurator) configurator;
      flowInfoTab =
        new FlowInfoTab(command, flowConfigurator.getFlow(),
          !isCommandFinished(), title, owner);
    }
    return flowInfoTab;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void commandUpdated(Type type, CommandInfo cmd) {
    super.commandUpdated(type, cmd);
    if (flowInfoTab != null) {
      if (!isCommandFinished()) {
        flowInfoTab.setProgress(cmd.getProgressData());
      }
      else {
        flowInfoTab.setProgress(null);
      }
    }
  }
}