package csbase.client.applications.flowapplication.filters;

import java.awt.geom.Point2D;

import tecgraf.vix.Message;
import tecgraf.vix.TypeMessage;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.actions.Action;
import csbase.client.applications.flowapplication.messages.GetPopupMessage;
import csbase.client.applications.flowapplication.messages.PickNodeMessage;

/**
 * Filtro que adiciona aes de menu popup de n de fluxo de algoritmos ao menu
 * popup.
 * 
 * @author lmoreira
 */
public abstract class AddNodePopupActionFilter extends WorkspaceFilter {

  /**
   * Cria a ao.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   */
  protected AddNodePopupActionFilter(final Workspace workspace) {
    super(workspace);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean msgHandlerVO(final TypeMessage msg) {
    handleMessage(msg);
    return super.msgHandlerVO(msg);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean msgHandlerVS(final TypeMessage msg) {
    handleMessage(msg);
    return super.msgHandlerVS(msg);
  }

  /**
   * Cria a ao.
   * 
   * @param graphNode O n de fluxo de algoritmos (No aceita {@code null}).
   * @param point O ponto onde o menu popup foi solicitado (No aceita
   *        {@code null}).
   * 
   * @return A ao.
   */
  protected abstract Action createAction(GraphNode graphNode, Point2D point);

  /**
   * <p>
   * Trata as {@link Message mensages} relevantes a este filtro e ignora outras
   * mensagens. A nica mensagem relevante  {@link GetPopupMessage}.
   * 
   * @param msg A mensagem.
   */
  private void handleMessage(final TypeMessage msg) {
    if (msg instanceof GetPopupMessage) {
      final GetPopupMessage getPopupMessage = (GetPopupMessage) msg;
      final Point2D point = getPopupMessage.getPoint();
      final PickNodeMessage pickNodeMessage = new PickNodeMessage(point);
      pickNodeMessage.sendVO(this);
      final GraphNode node = pickNodeMessage.getNode();
      if (node != null) {
        final Action action = createAction(node, point);
        if (action != null) {
          getPopupMessage.addPopupAction(action);
        }
      }
    }
  }
}
