/**
 * $Id: DefaultTextRenderer.java 141063 2013-05-16 15:46:28Z fpina $
 */

package csbase.client.applications.serverdiagnostic.monitor;

import java.util.List;

import csbase.logic.diagnosticservice.ResourceProperty;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.ValidationStatus;

/**
 * Renderer padro de um estado que formata as informaes em texto.
 * 
 * @author Tecgraf
 */
public class DefaultTextRenderer implements TextRenderer {
  /**
   * {@inheritDoc}
   */
  @Override
  public String getHeadline(Status status) {
    StringBuffer headline = new StringBuffer(status.getResourceName());
    headline.append(": ");
    headline.append(status.getCode());
    headline.append("\n");
    headline.append("[");
    headline.append(status.getTimestamp());
    headline.append("]");
    return headline.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDetails(Status status) {
    StringBuffer detail = new StringBuffer();
    detail.append(getValidationStatuses(status));
    detail.append(getProperties(status));
    return detail.toString();
  }

  /**
   * Obtm os {@link tecgraf.diagnostic.commom.ValidationStatus} do estado.
   * 
   * @param status o estado
   * 
   * @return os estados das validaes
   */
  private String getValidationStatuses(Status status) {
    StringBuffer validationsStatus = new StringBuffer();
    for (ValidationStatus se : status.getValidationStatusList()) {
      validationsStatus.append(se.code);
      validationsStatus.append(" ");
      validationsStatus.append(se.message);
      validationsStatus.append("\n");
    }
    return validationsStatus.toString();
  }

  /**
   * Obtm os parmetros do estado.
   * 
   * @param status o estado
   * 
   * @return os parmetros do estado
   */
  private String getProperties(Status status) {
    List<ResourceProperty> props = status.getProperties();
    StringBuffer parameters = new StringBuffer();
    for (ResourceProperty p : props) {
      parameters.append(p.name);
      parameters.append(" = ");
      parameters.append(p.value);
      parameters.append("\n");
    }
    return parameters.toString();
  }
}
