/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

final class GraphPoint {
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Stroke BORDER_STROKE = new BasicStroke(0.0f);
    private static final Color BORDER_COLOR = Color.BLACK;
    private static final int SIDE = 6;
    private static final Dimension DIMENSION = new Dimension(6, 6);
    private Point startPoint;
    private Point centerPoint;
    private Rectangle boundBox;

    GraphPoint(double x, double y) {
        Point point = new Point();
        point.setLocation(x, y);
        this.setLocation(x, y);
    }

    GraphPoint(Point2D point) {
        this(point.getX(), point.getY());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphPoint)) {
            return false;
        }
        GraphPoint point = (GraphPoint)obj;
        return this.boundBox.contains(point.centerPoint);
    }

    public int hashCode() {
        return this.centerPoint.hashCode();
    }

    public void paint(Graphics2D g) {
        int x = (int)this.startPoint.getX();
        int y = (int)this.startPoint.getY();
        g.setPaint(BACKGROUND_COLOR);
        g.fillRect(x, y, 6, 6);
        g.setPaint(BORDER_COLOR);
        g.setStroke(BORDER_STROKE);
        g.drawRect(x, y, 6, 6);
    }

    Rectangle2D getBounds() {
        return this.boundBox;
    }

    Point2D getLocation() {
        Point point = new Point();
        point.setLocation(this.centerPoint);
        return point;
    }

    void setLocation(double x, double y) {
        this.centerPoint = new Point();
        this.centerPoint.setLocation(x, y);
        this.startPoint = new Point();
        this.startPoint.setLocation(x - 3.0, y - 3.0);
        this.boundBox = new Rectangle();
        this.boundBox.setLocation(this.startPoint);
        this.boundBox.setSize(DIMENSION);
    }
}

