/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels;

import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.TablePanel;
import java.util.Date;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class SimpleTableModel
implements TableModel {
    private static final String EMPTY_PRJS = "@zero_projects";
    private final TablePanel tablePanel;

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public Object getValueAt(int row, int col) {
        List<ProjectsManagerData> projects = this.tablePanel.getVisibleProjects();
        if (projects == null) {
            return null;
        }
        if (projects.size() == 0) {
            return EMPTY_PRJS;
        }
        if (row >= projects.size() || row == -1) {
            return null;
        }
        ProjectsManagerData project = projects.get(row);
        if (col == 0) {
            return project.getScope();
        }
        if (col == 1) {
            return project.getProjectSpaceAllocation();
        }
        if (col == 2) {
            if (project.getProjectSpaceAllocation() == ProjectSpaceAllocation.WAITING_ALLOCATION) {
                return project.getRequestedSpace();
            }
            return project.getAllocatedSpace();
        }
        if (col == 3) {
            return project.getProjectName();
        }
        if (col == 4) {
            return project.getOwnerId();
        }
        if (col == 5) {
            return project.getOccupiedSpace();
        }
        if (col == 6) {
            return new Date(project.getCreationDate());
        }
        if (col == 7) {
            return new Date(project.getModificationDate());
        }
        if (col == 8) {
            return project.getServerOwnerName();
        }
        if (col == 9) {
            String locationServer = project.getLocationInServer();
            if (locationServer == null) {
                return "";
            }
            return locationServer;
        }
        throw new RuntimeException();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Object v = this.getValueAt(0, c);
        if (v == null) {
            return null;
        }
        return v.getClass();
    }

    @Override
    public int getRowCount() {
        List<ProjectsManagerData> visibleProjects = this.tablePanel.getVisibleProjects();
        return visibleProjects.size();
    }

    SimpleTableModel(TablePanel tablePanel) {
        this.tablePanel = tablePanel;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }
}

