/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.editors;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.resourcehelpers.PreferredAppDialog;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import csbase.logic.ProjectFileType;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public class PreferredAppEditor
extends PreferenceEditor<Map<String, String>> {
    public PreferredAppEditor(PreferenceValue<Map<String, String>> pv) {
        super(pv);
    }

    @Override
    protected JComponent createComponent() {
        Map value = (Map)this.getValue();
        int y = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        if (!value.isEmpty()) {
            for (Map.Entry entry : value.entrySet()) {
                JLabel type = this.createTypeLabel((String)entry.getKey());
                JLabel app = this.createAppLabel((String)entry.getValue());
                JButton chooser = this.createChooserButton((String)entry.getKey(), app);
                panel.add((Component)type, new GBC(0, y).insets(5).none());
                panel.add((Component)app, new GBC(1, y).horizontal());
                panel.add((Component)chooser, new GBC(2, y++).insets(5).none());
            }
        } else {
            JLabel noPreferredApp = new JLabel(this.getPrefixedString("no.preferred.applications"));
            noPreferredApp.setFont(font);
            panel.add(noPreferredApp);
        }
        this.setTitledBorder(panel);
        return panel;
    }

    private JLabel createAppLabel(String appId) {
        ApplicationManager am = ApplicationManager.getInstance();
        ImageIcon icon = am.getApplicationIcon(appId);
        JLabel label = new JLabel(icon);
        label.setToolTipText(this.getAppName(appId));
        return label;
    }

    private JButton createChooserButton(final String fileType, final JLabel app) {
        JButton button = new JButton(this.getPrefixedString("choose"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationManager am = ApplicationManager.getInstance();
                List<String> apps = am.getApplicationsFromType(fileType);
                PreferredAppDialog dialog = new PreferredAppDialog(null, apps, fileType, false);
                dialog.setVisible(true);
                String appId = dialog.getSelectedApp();
                if (appId != null) {
                    app.setIcon(am.getApplicationIcon(appId));
                    app.setToolTipText(PreferredAppEditor.this.getAppName(appId));
                    ((Map)PreferredAppEditor.this.getValue()).put(fileType, appId);
                    PreferredAppEditor.this.notifyListeners();
                }
            }
        });
        button.setEnabled(this.isEditable());
        return button;
    }

    private String getAppName(String appId) {
        ApplicationManager am = ApplicationManager.getInstance();
        ApplicationRegistry registry = am.getApplicationRegistry(appId);
        return am.getApplicationName(registry);
    }

    private JLabel createTypeLabel(String key) {
        ProjectFileType type = ProjectFileType.getFileType((String)key);
        JLabel label = new JLabel(type.getDescription());
        label.setFont(font);
        return label;
    }
}

