/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsynchronization;

import csbase.client.applications.projectsynchronization.ContainerSelectionFiles;
import csbase.client.applications.projectsynchronization.StepProjectSynchronization;
import csbase.logic.ProjectSynchronizationFileInfo;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.WizardException;

public abstract class StepSelectionFiles
extends StepProjectSynchronization {
    protected ContainerSelectionFiles containerSelectionFiles;
    protected ApplicationRegistry registry;
    protected String serverNameA;
    protected String projectNameA;
    protected String serverNameB;
    protected String projectNameB;

    StepSelectionFiles(ApplicationRegistry registry) {
        this.registry = registry;
        this.containerSelectionFiles = new ContainerSelectionFiles(registry);
    }

    protected void enter(History history) throws WizardException {
        this.serverNameA = (String)history.get(null, "serverNameA");
        this.projectNameA = (String)history.get(null, "projectNameA");
        this.serverNameB = (String)history.get(null, "serverNameB");
        this.projectNameB = (String)history.get(null, "projectNameB");
    }

    protected void completeContainerSelection(Map map, List excludeItems) {
        ArrayList<ProjectSynchronizationFileInfo> items = new ArrayList<ProjectSynchronizationFileInfo>();
        ArrayList<ProjectSynchronizationFileInfo> selectedItems = new ArrayList<ProjectSynchronizationFileInfo>();
        for (ProjectSynchronizationFileInfo psfi : map.values()) {
            if (excludeItems != null && excludeItems.contains(psfi.generateAbsoluteFilename())) continue;
            if (psfi.getTransfer()) {
                selectedItems.add(psfi);
                continue;
            }
            items.add(psfi);
        }
        this.containerSelectionFiles.getContainerSelection().loadItems(items, selectedItems);
    }

    protected Container getContainer() {
        return this.containerSelectionFiles.getRootPanel();
    }

    protected List<String> confirmSelection(Map map) {
        ArrayList<String> selectedItems = new ArrayList<String>();
        for (ProjectSynchronizationFileInfo psfi : map.values()) {
            psfi.setTransfer(false);
        }
        List list = this.containerSelectionFiles.getContainerSelection().getSelectedItems();
        for (ProjectSynchronizationFileInfo psfi : list) {
            psfi.setTransfer(true);
            selectedItems.add(psfi.generateAbsoluteFilename());
        }
        return selectedItems;
    }
}

