/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class StatusModificationTask
extends ProjectsManagerTask<List<ProjectsManagerData>> {
    private List<ProjectsManagerData> projects;
    private ProjectSpaceAllocation targetAllocationStatus;
    private int reservedSpace;

    public StatusModificationTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects, ProjectSpaceAllocation targetAllocationStatus, int reservedSpace) {
        super(projectsManager);
        this.projects = projects;
        this.targetAllocationStatus = targetAllocationStatus;
        this.reservedSpace = reservedSpace;
    }

    public StatusModificationTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects) {
        this(projectsManager, projects, ProjectSpaceAllocation.NO_ALLOCATION, 0);
    }

    protected void performTask() {
        ArrayList<ProjectsManagerData> list = new ArrayList<ProjectsManagerData>();
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        for (ProjectsManagerData prj : this.projects) {
            try {
                if (this.targetAllocationStatus == ProjectSpaceAllocation.NO_ALLOCATION) {
                    psi.setAllocatedProjectAsUnallocated(prj.getProjectId());
                    continue;
                }
                if (this.targetAllocationStatus == ProjectSpaceAllocation.ALLOCATED) {
                    psi.setUnallocatedProjectAsAllocated(prj.getProjectId(), this.reservedSpace);
                    continue;
                }
                psi.setUnallocatedProjectAsLocked(prj.getProjectId(), this.reservedSpace);
            }
            catch (RemoteException re) {
                list.add(prj);
            }
        }
        this.setResult(list);
    }
}

