/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.textviewer;

import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.core.lng.LNG;

public class TextViewer {
    private String text;
    private String title;
    private final DesktopComponentFrame mainFrame;

    public final void showDialog() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        DesktopComponentFrame desktopFrame = desktop.getDesktopFrame();
        this.mainFrame.center(desktopFrame);
        this.mainFrame.setVisible(true);
    }

    private DesktopComponentFrame createMainFrame() {
        final DesktopComponentFrame frm = new DesktopComponentFrame("");
        frm.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                frm.close();
            }
        });
        Container cp = frm.getContentPane();
        cp.add((Component)this.createViewer(), "Center");
        cp.add((Component)this.createButtonsPanel(), "South");
        frm.setTitle(this.title);
        frm.setSize(600, 400);
        return frm;
    }

    private JComponent createViewer() {
        JEditorPane textPane = new JEditorPane();
        textPane.setFont(new Font("Monospaced", 0, 12));
        textPane.setEditable(false);
        textPane.setText(this.text);
        JScrollPane textScrolledPane = new JScrollPane(textPane);
        textScrolledPane.setVerticalScrollBarPolicy(22);
        return textScrolledPane;
    }

    private JPanel createButtonsPanel() {
        JPanel bp = new JPanel(new FlowLayout());
        JButton exitButton = new JButton(LNG.get((String)"textviewer.button.exit"));
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TextViewer.this.mainFrame.close();
            }
        });
        bp.add(exitButton);
        return bp;
    }

    public TextViewer(String text) {
        this(text, LNG.get((String)"textviewer.title"));
    }

    public TextViewer(String text, String title) {
        this.text = text;
        this.title = title;
        this.mainFrame = this.createMainFrame();
    }
}

