/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.openbus;

import csbase.client.desktop.DesktopFrame;
import csbase.client.openbus.OpenBusAccessPoint;
import csbase.client.openbus.OpenBusEventHandlerInterface;

public class OpenBusEventHandler
implements OpenBusEventHandlerInterface {
    protected final String getClientInstanceId() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        return desktop.getClientInstanceId();
    }

    protected final String getFatherClientInstanceId() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        return desktop.getFatherClientInstanceId();
    }

    protected final boolean isMyId(String id) {
        if (this.isAnonymousId(id)) {
            return false;
        }
        String myId = this.getClientInstanceId();
        if (myId == null) {
            return false;
        }
        boolean isMe = myId.equals(id.trim());
        return isMe;
    }

    protected final boolean isMyFatherId(String id) {
        if (id == null) {
            return false;
        }
        String fatherId = this.getFatherClientInstanceId();
        if (fatherId == null) {
            return false;
        }
        boolean isMyFather = id.equals(fatherId.trim());
        return isMyFather;
    }

    protected final boolean isAnonymousId(String id) {
        return id == null;
    }

    protected final boolean isEventFromFatherAndToMe(String sourceId, String destId) {
        if (this.isAnonymousId(destId)) {
            return false;
        }
        if (this.isAnonymousId(sourceId)) {
            return false;
        }
        if (!this.isMyId(destId)) {
            return false;
        }
        return this.isMyFatherId(sourceId);
    }

    protected final boolean isEventFromIdentifiedSourceAndToMe(String sourceId, String destId) {
        if (this.isAnonymousId(sourceId)) {
            return false;
        }
        return this.isMyId(destId);
    }

    @Override
    public boolean receiveEventWithNoValue(String sourceId, String destId, String type) {
        return false;
    }

    @Override
    public boolean receiveEventWithStringValue(String sourceId, String destId, String type, String stringValue) {
        return false;
    }

    @Override
    public boolean receiveEventWithBooleanValue(String sourceId, String destId, String type, boolean booleanValue) {
        return false;
    }

    @Override
    public final boolean sendEventWithNoValue(String sourceId, String destId, String type) {
        OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
        boolean treated = oap.getSession().internalSendEventWithNoValue(sourceId, destId, type);
        this.logSentEvent(treated, sourceId, destId, type, null);
        return treated;
    }

    @Override
    public final boolean sendEventWithStringValue(String sourceId, String destId, String type, String stringValue) {
        OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
        boolean treated = oap.getSession().internalSendEventWithStringValue(sourceId, destId, type, stringValue);
        this.logSentEvent(treated, sourceId, destId, type, stringValue);
        return treated;
    }

    @Override
    public final boolean sendEventWithBooleanValue(String sourceId, String destId, String type, boolean booleanValue) {
        OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
        boolean treated = oap.getSession().internalSendEventWithBooleanValue(sourceId, destId, type, booleanValue);
        this.logSentEvent(treated, sourceId, destId, type, booleanValue);
        return treated;
    }

    public OpenBusEventHandler() {
        OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
        oap.getSession().addEventReceiver(this);
    }

    @Override
    public void logReceivedEvent(boolean treated, String sourceId, String destId, String type, Object value) {
    }

    @Override
    public void logSentEvent(boolean treated, String sourceId, String destId, String type, Object value) {
    }
}

