/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.externalresources;

import csbase.client.Client;
import csbase.client.externalresources.JNLPLocalFile;
import csbase.client.externalresources.LocalFile;
import csbase.exception.CSBaseException;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public final class ExternalResources {
    private static final String JNLP_UNAVAILABLE_MESSAGE = "Funcionalidade JNLP indispon\u00edvel";
    private static final String INVALID_URL_MESSAGE = "Endere\u00e7o inv\u00e1lido";
    private static final String SHOW_DOCUMENT_ERROR_MESSAGE = "Erro ao acessar o documento: {0}";
    private static final String DESKTOP_NOT_SUPPORTED_MESSAGE = "N\u00e3o foi poss\u00edvel iniciar o navegador padr\u00e3o.\nPor favor acesse diretamente o link:\n{0}";
    private static ExternalResources instance;

    private ExternalResources() {
    }

    public static ExternalResources getInstance() {
        if (instance == null) {
            instance = new ExternalResources();
        }
        return instance;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean showDocument(URL url) throws CSBaseException {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            throw new CSBaseException(DESKTOP_NOT_SUPPORTED_MESSAGE, new Object[]{url.toExternalForm()});
        }
        try {
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (Exception e) {
            throw new CSBaseException(SHOW_DOCUMENT_ERROR_MESSAGE, new Object[]{e.getMessage()});
        }
        return true;
    }

    public URL getCodeBase() throws CSBaseException {
        URL appUrl;
        try {
            appUrl = new URL(Client.getInstance().getAppAddress());
        }
        catch (MalformedURLException e) {
            throw new CSBaseException(INVALID_URL_MESSAGE);
        }
        return appUrl;
    }

    @Deprecated
    public LocalFile openFileDialog(String pathHint, String[] extensions) throws IOException, CSBaseException {
        throw new CSBaseException(JNLP_UNAVAILABLE_MESSAGE);
    }

    @Deprecated
    public LocalFile[] openMultiFileDialog(String pathHint, String[] extensions) throws IOException, CSBaseException {
        throw new CSBaseException(JNLP_UNAVAILABLE_MESSAGE);
    }

    @Deprecated
    public LocalFile saveFileDialog(String pathHint, String[] extensions, InputStream inputStream, String name) throws CSBaseException {
        throw new CSBaseException(JNLP_UNAVAILABLE_MESSAGE);
    }

    @Deprecated
    public LocalFile saveAsFileDialog(String pathHint, String[] extensions, JNLPLocalFile localFile) throws CSBaseException {
        throw new CSBaseException(JNLP_UNAVAILABLE_MESSAGE);
    }
}

