/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.algorithms.executor;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.desktop.RemoteTask;
import csbase.client.facilities.algorithms.executor.AbstractCommandExecutor;
import csbase.client.facilities.algorithms.executor.CommandConfiguration;
import csbase.client.facilities.algorithms.executor.CommandObserver;
import csbase.client.facilities.algorithms.parameters.FlowParametersValues;
import csbase.client.facilities.algorithms.parameters.NodeParametersValues;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.sga.CommandRequestedListener;
import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.ClientFile;
import csbase.logic.CommandInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowAlgorithmParser;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public class FlowCommandExecutor
extends AbstractCommandExecutor {
    public FlowAlgorithmConfigurator getConfigurator(String algorithmName, AlgorithmVersionId versionId, Window owner) {
        CommandConfiguration commandConfig = new CommandConfiguration(algorithmName, versionId, owner);
        AlgorithmConfigurator configurator = commandConfig.getConfigurator();
        AlgorithmConfigurator.ConfiguratorType cnfType = configurator.getConfiguratorType();
        if (cnfType == AlgorithmConfigurator.ConfiguratorType.FLOW) {
            return (FlowAlgorithmConfigurator)configurator;
        }
        return null;
    }

    public boolean executeIterativeCommand(Flow flow, Map<Integer, NodeParametersValues> paramValuesList, String description, boolean openFlowApplication, String sgaServerName, Window owner, CommandObserver ... observers) throws RemoteException, OperationFailureException {
        return this.executeFlowApplication(flow, paramValuesList, description, owner);
    }

    public String executeCommand(Flow flow, Map<Integer, NodeParametersValues> paramValuesList, String description, boolean openFlowApplication, String sgaServerName, Window owner, CommandObserver ... observers) throws RemoteException, OperationFailureException {
        Graph graph = this.createGraph(flow, owner);
        if (!this.configureGraphNodesValues(graph, paramValuesList, owner)) {
            return null;
        }
        FlowAlgorithmConfigurator conf = new FlowAlgorithmConfigurator(graph.toFlow());
        String executed = this.executeCommand((AlgorithmConfigurator)conf, description, sgaServerName, owner, observers);
        return executed;
    }

    public String executeCommand(FlowParametersValues paramValuesList, String description, boolean openFlowApplication, String sgaServerName, Window owner, CommandObserver ... observers) throws RemoteException, OperationFailureException {
        FlowAlgorithmConfigurator flowConfigurator = this.getConfigurator(paramValuesList.getFlowName(), paramValuesList.getFlowVersionId(), owner);
        return this.executeCommand(flowConfigurator.getFlow(), paramValuesList.getParametersValuesList(), description, openFlowApplication, sgaServerName, owner, observers);
    }

    public String executeCommand(ClientFile file, Map<Integer, NodeParametersValues> paramValuesList, String description, boolean openFlowApplication, String sgaServerName, Window owner, CommandObserver ... observers) throws ParseException, OperationFailureException, IOException {
        try (InputStream inputStream = file.getInputStream();){
            FlowAlgorithmParser parser = new FlowAlgorithmParser();
            Flow flow = parser.read(inputStream);
            String string = this.executeCommand(flow, paramValuesList, description, openFlowApplication, sgaServerName, owner, observers);
            return string;
        }
    }

    private boolean executeFlowApplication(Flow flow, Map<Integer, NodeParametersValues> paramValuesList, String commandDescription, Window owner) {
        try {
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            FlowApplication flowApp = applicationManager.runApplication(FlowApplication.class);
            ApplicationFrame frame = flowApp.getApplicationFrame();
            Graph graph = this.createGraph(flow, frame);
            if (!this.configureGraphNodesValues(graph, paramValuesList, owner)) {
                applicationManager.killApplication(flowApp);
                return false;
            }
            flowApp.setGraph(graph, commandDescription);
            flowApp.hideAlgorithmTreePanel();
            flowApp.addCommandRequestedListener(new CommandRequestedListener(){

                @Override
                public void commandsWereRequested(Set<CommandInfo> submittedCommands) {
                    if (!submittedCommands.isEmpty()) {
                        Iterator<CommandInfo> iterator = submittedCommands.iterator();
                        FlowCommandExecutor.this.setCommandId(iterator.next().getId());
                        FlowCommandExecutor.this.notifyCommandRequestedListeners(submittedCommands);
                    }
                }
            });
            return true;
        }
        catch (ApplicationException e) {
            StandardErrorDialogs.showExceptionDialog(owner, owner.getName(), e);
            return false;
        }
    }

    private boolean configureGraphNodesValues(Graph graph, Map<Integer, NodeParametersValues> paramValuesList, Window owner) {
        if (paramValuesList == null) {
            return true;
        }
        for (Map.Entry<Integer, NodeParametersValues> entry : paramValuesList.entrySet()) {
            String msgTag;
            GraphNode graphNode = graph.getNode(entry.getKey());
            if (graphNode == null) {
                String msgTag2 = "FlowCommandExecutor.msg.error.invalid.node";
                String msg = LNG.get((String)"FlowCommandExecutor.msg.error.invalid.node");
                StandardErrorDialogs.showErrorDialog(owner, msg);
                return false;
            }
            try {
                NodeParametersValues value = entry.getValue();
                Map<String, String> allValues = value.getAllParametersValues();
                graphNode.setParameterValuesByName(allValues);
            }
            catch (ParseException pe) {
                msgTag = "FlowCommandExecutor.msg.error.invalid.params";
                String msg = LNG.get((String)"FlowCommandExecutor.msg.error.invalid.params");
                StandardErrorDialogs.showErrorDialog(owner, msg, (Throwable)pe);
                return false;
            }
            catch (ParameterNotFoundException e) {
                msgTag = "FlowCommandExecutor.msg.error.invalid.params";
                String msg = LNG.get((String)"FlowCommandExecutor.msg.error.invalid.params");
                StandardErrorDialogs.showErrorDialog(owner, msg, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private Graph createGraph(final Flow flow, final Window frame) {
        RemoteTask<Graph> task = new RemoteTask<Graph>(){

            protected void performTask() throws Exception {
                Graph graph = new Graph(frame, flow);
                this.setResult(graph);
            }
        };
        String title = "Criando o grafo do fluxo";
        String msg = "Carregando informa\u00e7\u00f5es do fluxo.";
        if (!task.execute(frame, "Criando o grafo do fluxo", "Carregando informa\u00e7\u00f5es do fluxo.")) {
            return null;
        }
        return (Graph)task.getResult();
    }
}

