/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.types;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.util.PreferenceBundle;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PVMap
extends PreferenceValue<Map<String, String>> {
    public PVMap(PreferenceDefinition name, String value, String defaultValue, PreferencePolicy policy, PreferenceBundle preferenceBundle) {
        super(name, value, defaultValue, policy, preferenceBundle);
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : ((Map)this.getValue()).entrySet()) {
            builder.append((String)entry.getKey());
            builder.append("=");
            builder.append((String)entry.getValue());
            builder.append(";");
        }
        return builder.toString();
    }

    @Override
    public Map<String, String> toValue(String value) {
        Pattern p = Pattern.compile("(.*?)=(.*?);");
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher m = p.matcher(value);
        while (m.find()) {
            result.put(m.group(1), m.group(2));
        }
        return result;
    }

    @Override
    public PreferenceValue<Map<String, String>> clone() {
        PVMap clone = new PVMap(this.name, this.toString(), this.defaultValue, this.policy, this.preferenceBundle);
        clone.setPreferenceEditorClass(this.getPreferenceEditorClass());
        return clone;
    }

    public void put(String key, String value) {
        ((Map)this.getValue()).put(key, value);
    }

    public boolean containsKey(String key) {
        return ((Map)this.getValue()).containsKey(key);
    }

    public String get(String key) {
        return (String)((Map)this.getValue()).get(key);
    }
}

