/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ParameterGroupView;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.ParameterViewFactory;
import csbase.client.algorithms.view.simple.SimpleAlgorithmConfiguratorPanel;
import csbase.exception.OperationFailureException;
import csbase.logic.algorithms.parameters.AbstractFileParameter;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;

public class DefaultParameterViewFactory
implements ParameterViewFactory {
    @Override
    public ParameterView<?> create(SimpleAlgorithmConfiguratorPanel configurationPanel, Parameter<?> parameter, ParameterView.Mode mode) {
        try {
            return this.createCustomParameterView(parameter, mode, "logic", "client");
        }
        catch (Exception e) {
            AbstractFileParameter fileParameter;
            if (parameter instanceof ParameterGroup) {
                ParameterGroup parameterGroup = (ParameterGroup)parameter;
                return new ParameterGroupView(configurationPanel, parameterGroup, mode);
            }
            if (parameter instanceof AbstractFileParameter && ((fileParameter = (AbstractFileParameter)parameter).hasLink() || fileParameter.usesPipe() == FileParameterPipeAcceptance.ALWAYS)) {
                return null;
            }
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel criar a vis\u00e3o do par\u00e2metro: " + parameter.getClass().getName() + ". Erro: " + e + " .", e.getCause());
        }
    }

    protected ParameterView<?> createCustomParameterView(Parameter<?> parameter, ParameterView.Mode mode, String logicPackageName, String clientPackageName) throws OperationFailureException {
        ParameterView view;
        Constructor<?> viewConstructor;
        Class<?> viewClass;
        String parameterClassName = parameter.getClass().getName();
        String parameterViewClassName = parameterClassName + "View";
        if (!parameterViewClassName.contains("." + logicPackageName + ".")) {
            throw new OperationFailureException("A classe {0} precisa estar no pacote {1}", new Object[]{parameterViewClassName, logicPackageName});
        }
        String replacedParameterViewClassName = parameterViewClassName.replaceFirst("\\." + logicPackageName + "\\.", "." + clientPackageName + ".");
        try {
            viewClass = Class.forName(replacedParameterViewClassName);
        }
        catch (ClassNotFoundException e) {
            throw new OperationFailureException("A classe {0} n\u00e3o foi encontrada", new Object[]{replacedParameterViewClassName});
        }
        if (!ParameterView.class.isAssignableFrom(viewClass)) {
            throw new OperationFailureException("A classe {0} n\u00e3o implementa a interface necess\u00e1ria {1}", new Object[]{replacedParameterViewClassName, ParameterView.class.getName()});
        }
        try {
            viewConstructor = viewClass.getConstructor(parameter.getClass(), ParameterView.Mode.class);
        }
        catch (NoSuchMethodException e) {
            throw new OperationFailureException("N\u00e3o existe um construtor p\u00fablico com par\u00e2metros dos tipos {0} e {1} em {2}", new Object[]{parameter.getClass().getSimpleName(), ParameterView.Mode.class.getSimpleName(), replacedParameterViewClassName});
        }
        try {
            view = (ParameterView)viewConstructor.newInstance(new Object[]{parameter, mode});
        }
        catch (InstantiationException e) {
            throw new OperationFailureException(MessageFormat.format("N\u00e3o foi poss\u00edvel construir a f\u00e1brica {0}", replacedParameterViewClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OperationFailureException(MessageFormat.format("Construtor da f\u00e1brica {0} n\u00e3o aceita os par\u00e2metros usados", replacedParameterViewClassName), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new OperationFailureException(MessageFormat.format("Erro ao criar a f\u00e1brica de par\u00e2metros {0}", replacedParameterViewClassName), e.getTargetException());
        }
        return view;
    }
}

