/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.MailServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class AdminSendEmailTask
extends ProjectsManagerTask<String[]> {
    private final Map<Object, Set<String>> userProjectMap;
    private final String mailSubject;
    private final String mailText;
    final boolean copyAdmin;

    public AdminSendEmailTask(ProjectsManager projectsManager, Map<Object, Set<String>> userProjectMap, String mailSubject, String mailText, boolean copyAdmin) {
        super(projectsManager);
        this.userProjectMap = userProjectMap;
        this.mailSubject = mailSubject;
        this.mailText = mailText;
        this.copyAdmin = copyAdmin;
    }

    protected void performTask() {
        ArrayList<Object> list = new ArrayList<Object>();
        MailServiceInterface msi = ClientRemoteLocator.mailService;
        Set<Object> users = this.userProjectMap.keySet();
        User u = User.getLoggedUser();
        String[] ownMails = u.getEmails();
        if (ownMails == null || ownMails.length == 0) {
            this.setResult(list.toArray(new String[0]));
            return;
        }
        String[] cco = null;
        if (this.copyAdmin) {
            ArrayList<String> adminMails = new ArrayList<String>();
            try {
                for (User admin : User.getAdmins()) {
                    String[] mails = admin.getEmails();
                    if (mails == null) continue;
                    for (String mail : mails) {
                        adminMails.add(mail);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cco = adminMails.toArray(new String[adminMails.size()]);
        }
        for (Object user : users) {
            String ajustedMailText = this.adjustMailText(user);
            try {
                User us = User.getUser((Object)user);
                if (us == null) {
                    list.add(user);
                    continue;
                }
                String[] userMails = us.getEmails();
                if (userMails == null || userMails.length == 0) {
                    list.add(user);
                    continue;
                }
                msi.sendMail(ownMails[0], userMails, ajustedMailText, this.mailSubject, null, cco);
            }
            catch (RemoteException re) {
                list.add(user);
            }
        }
        if (list.size() > 0) {
            this.setResult(list.toArray(new String[list.size()]));
        } else {
            this.setResult(null);
        }
    }

    private String adjustMailText(Object userId) {
        if (userId == null) {
            return "";
        }
        StringBuilder defaultNote = new StringBuilder(this.getString("AdminSendEmailTask.default.mail.note.text"));
        Set<String> projects = this.userProjectMap.get(userId);
        if (projects == null) {
            return "";
        }
        for (String str : projects) {
            defaultNote.append(" " + str + ",");
        }
        return this.mailText + "\n" + defaultNote.substring(0, defaultNote.length() - 1);
    }
}

