/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph.actions;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.actions.Action;
import csbase.client.applications.flowapplication.graph.actions.GraphElementAction;
import csbase.client.applications.flowapplication.graph.utils.GraphNodeUpdateOperation;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public class UpdateVersionAction
extends GraphElementAction {
    protected UpdateVersionAction(GraphNode node) {
        super(node, UpdateVersionAction.class.getName() + ".name", ApplicationImages.ICON_REFRESH_16);
        this.setEnabled(GraphNodeUpdateOperation.hasNewerVersion(node));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        GraphNode node = (GraphNode)this.getElement();
        GraphNodeUpdateOperation operation = new GraphNodeUpdateOperation(node);
        boolean result = operation.update();
        if (!result) {
            this.showErrorDialog(MessageFormat.format(LNG.get((String)(UpdateVersionAction.class.getName() + ".error")), node.getAlgorithmName()));
        }
    }

    public static WorkspaceFilter createFilter(Workspace workspace) {
        return new AddNodePopupActionFilter(workspace){

            @Override
            protected Action createAction(GraphNode graphNode, Point2D point) {
                return new UpdateVersionAction(graphNode);
            }
        };
    }
}

