/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.Client;
import csbase.client.desktop.LoginAsDesktopAction;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.exception.CSBaseRuntimeException;
import csbase.logic.PreLoginData;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ServerEntryPoint;
import java.util.HashMap;
import java.util.Locale;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.launcher.Launcher;

class LoginAsTask
extends RemoteTask<Void> {
    private final LoginAsDesktopAction action;

    @Override
    protected void handleError(Exception error) {
        String message = error.getMessage();
        this.action.showErrorMessage(message);
    }

    @Override
    protected void handleServerError(CSBaseRuntimeException cserror) {
        String message = cserror.getMessage();
        this.action.showErrorMessage(message);
    }

    public void performTask() throws Exception {
        ServerEntryPoint serverEntryPoint = ClientRemoteLocator.server;
        Locale locale = LNG.getLocale();
        ClientRemoteMonitor clientRemoteMonitor = ClientRemoteMonitor.getInstance();
        String userLogin = clientRemoteMonitor.getLogin();
        HashMap<String, String> attributes = serverEntryPoint.getSessionAttributes((Object)userLogin);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        attributes.put("realUser", userLogin);
        PreLoginData preLoginData = serverEntryPoint.preLogin(this.action.getNewLogin(), "", locale, attributes);
        Client client = Client.getInstance();
        String appURL = client.getAppAddress();
        String env = client.getParameter("launcher_env");
        String tokenParam = "--token " + preLoginData.getToken();
        Launcher launcher = this.action.getLauncher();
        launcher.executeNewLauncher(appURL, env, new String[]{tokenParam});
    }

    public LoginAsTask(LoginAsDesktopAction action) {
        this.action = action;
    }
}

