/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote;

import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.logic.AdministrationEvent;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.ProjectUserEvent;
import csbase.logic.SharedProjectEvent;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import java.rmi.RemoteException;
import java.util.Observable;

public class ProjectAdminObserver
extends Observable {
    private static ProjectAdminObserver instance = null;
    private IMessageListener adminstrationEventListener;
    private IMessageListener projectUserEventListener;
    private IMessageListener sharedProjectEventListener;

    public static void start() throws RemoteException {
        if (instance != null) {
            return;
        }
        instance = new ProjectAdminObserver();
    }

    public static void stop() throws RemoteException {
        if (instance == null) {
            return;
        }
        instance.uninstall();
    }

    public static ProjectAdminObserver getInstance() {
        return instance;
    }

    private void registerAdminstrationEventListener() {
        this.adminstrationEventListener = new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    AdministrationEvent event = (AdministrationEvent)message.getBody();
                    ProjectAdminInfo.update((AdministrationEvent)event);
                }
            }
        };
        MessageProxy.addListener(this.adminstrationEventListener, AdministrationEvent.class);
    }

    private void registerProjectUserEventListener() {
        this.projectUserEventListener = new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    ProjectUserEvent event = (ProjectUserEvent)message.getBody();
                    ProjectAdminObserver.this.setChanged();
                    ProjectAdminObserver.this.notifyObservers(event);
                }
            }
        };
        MessageProxy.addListener(this.projectUserEventListener, ProjectUserEvent.class);
    }

    private void registerSharedProjectEventListener() {
        this.sharedProjectEventListener = new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    SharedProjectEvent event = (SharedProjectEvent)message.getBody();
                    ProjectAdminObserver.this.setChanged();
                    ProjectAdminObserver.this.notifyObservers(event);
                }
            }
        };
        MessageProxy.addListener(this.sharedProjectEventListener, SharedProjectEvent.class);
    }

    public void install() {
        this.registerAdminstrationEventListener();
        this.registerProjectUserEventListener();
        this.registerSharedProjectEventListener();
    }

    public void uninstall() {
        MessageProxy.removeListener(this.adminstrationEventListener);
        MessageProxy.removeListener(this.projectUserEventListener);
        MessageProxy.removeListener(this.sharedProjectEventListener);
    }

    protected ProjectAdminObserver() throws RemoteException {
        this.install();
    }
}

