/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.ProjectAllocationState;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.util.List;

public class ReloadSelectedProjectsTask
extends ProjectsManagerTask<List<ProjectsManagerData>> {
    private List<ProjectsManagerData> projectsManagerData;

    public ReloadSelectedProjectsTask(ProjectsManager projectsManager, List<ProjectsManagerData> projectsManagerData) {
        super(projectsManager);
        this.projectsManagerData = projectsManagerData;
    }

    protected void performTask() throws Exception {
        this.getProjectsData();
        this.setResult(this.projectsManagerData);
    }

    private void getProjectsData() throws Exception {
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        for (int i = 0; i < this.projectsManagerData.size(); ++i) {
            CommonClientProject ccp;
            long allocatedSpace;
            ProjectsManagerData pmd = this.projectsManagerData.get(i);
            ProjectAdminInfo projectAdminInfo = psi.getProjectAdminInfo(pmd.getProjectId());
            if (projectAdminInfo != null) {
                ProjectAllocationState state = projectAdminInfo.getState();
                ProjectSpaceAllocation spaceAllocation = ProjectSpaceAllocation.getItemFromAllocationState(state);
                pmd.setProjectSpaceAllocation(spaceAllocation);
                if (!projectAdminInfo.isUnlockedWithAreaAllocated()) {
                    pmd.clearData();
                    continue;
                }
            }
            if ((allocatedSpace = (ccp = psi.openProject(pmd.getProjectId(), false)).getLockingAreaSize()) == 0L) {
                pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.NO_ALLOCATION);
            } else if (allocatedSpace > 0L) {
                pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.ALLOCATED);
            }
            String userName = User.getName((Object)ccp.getUserId());
            pmd.setOwnerName(userName);
            pmd.setProjectDescription(ccp.getDescription());
            pmd.setCreationDate(ccp.getCreationDate());
            pmd.setServerOwnerName(ccp.getOwnerServerName());
            pmd.setLocationInServer(ccp.getLocationInServer());
            pmd.setModificationDate(ccp.getLastModificationDate());
            pmd.setSharingType(ccp.getSharingType());
            pmd.setUsers(ccp.getUsersRO(), ccp.getUsersRW());
            ccp.close(false);
        }
    }
}

