package csbase.client.applications.jobmonitor.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.jobmonitor.JobInfoDialog;
import csbase.client.applications.jobmonitor.JobMonitor;
import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;

/**
 * Ao que detalha um jobinfo.
 * 
 * @author Tecgraf
 */
public class DetailsJobInfoAction extends
  AbstractSimpleApplicationAction<JobMonitor> {

  /**
   * Construtor padro.
   * 
   * @param application - referncia para a aplicao.
   */
  public DetailsJobInfoAction(JobMonitor application) {
    super(application, ApplicationImages.ICON_DETAILS_16);
    setEnabled(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    JobMonitor app = getApplication();

    JobInfoRow jobInfoRow = app.getSelectedObject();

    JobInfoDialog dialog = new JobInfoDialog(getApplication(), jobInfoRow);
    app.addObserver(dialog);

    dialog.setVisible(true);
  }
}
