package csbase.client.applications.projectsmanager.panels;

import java.awt.CardLayout;
import java.util.List;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;

/**
 * Painel que apresenta os paineis especficos em funo da seleo na tabela
 * feita pelo usurio (uma linha selecionada ou vrias linhas selecionadas).
 * 
 * @author Tecgraf/PUC-Rio
 */
public class InfoPanel extends ProjectsManagerPanel {

  /**
   * Layout do painel.
   */
  final private CardLayout cardLayout = new CardLayout();

  /**
   * Painel que apresenta dados de projeto no caso de apenas uma linha ser
   * selecionada.
   */
  final private SingleSelectionPanel singleSelectionPanel;

  /**
   * Painel que apresenta dados de projeto no caso de mais de umas uma linha ser
   * selecionada.
   */
  final private MultipleSelectionPanel multipleSelectionPanel;

  /**
   * Id de painel simples
   */
  private static final String SINGLE_SELECTION_PANEL = "SingleSelectionPanel";

  /**
   * Id de painel mltiplo.
   */
  private static final String MULTIPLE_SELECTION_PANEL =
    "MultipleSelectionPanel";

  /**
   * Painel corrente (o com informaes de apenas um projeto ou o com
   * informaes sobre mltiplos projetos).
   */
  private AbstractProjectManagerInfoPanel currentPanel;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public InfoPanel(final ProjectsManager projectsManager) {
    super(projectsManager);
    singleSelectionPanel = new SingleSelectionPanel(projectsManager);
    multipleSelectionPanel = new MultipleSelectionPanel(projectsManager);
    buildPanel();
  }

  /**
   * Monta o painel.
   */
  private void buildPanel() {

    setLayout(cardLayout);

    add(singleSelectionPanel, SINGLE_SELECTION_PANEL);
    cardLayout.addLayoutComponent(singleSelectionPanel, SINGLE_SELECTION_PANEL);

    add(multipleSelectionPanel, MULTIPLE_SELECTION_PANEL);
    cardLayout.addLayoutComponent(multipleSelectionPanel,
      MULTIPLE_SELECTION_PANEL);
  }

  /**
   * Limpa os campos dos paineis.
   */
  public void clearFields() {
    singleSelectionPanel.clearFields();
    multipleSelectionPanel.clearFields();
  }

  /**
   * Atualiza a lista de projetos selecionados no painel adequado, dependendo de
   * quantos projetos esto selecionados (apenas um ou mltiplos).
   * 
   * @param selectedProjects - lista de projetos selecionados
   */
  public void setSelectedProjects(

  final List<ProjectsManagerData> selectedProjects) {
    if (selectedProjects == null) {
      return;
    }

    if (selectedProjects.size() == 1) {
      // Painel SINGLE ROW SELECTED
      currentPanel = singleSelectionPanel;
      singleSelectionPanel.setProjectsManagerData(selectedProjects.get(0));
      cardLayout.show(this, SINGLE_SELECTION_PANEL);
    }
    else {
      // Painel MULTIPLE ROWS SELECTED
      currentPanel = multipleSelectionPanel;
      multipleSelectionPanel.setProjectsManagerData(selectedProjects);
      cardLayout.show(this, MULTIPLE_SELECTION_PANEL);
    }
    revalidate();
    repaint();
  }

  /**
   * Atualiza as informaes do painel.
   */
  public void updateFields() {
    currentPanel.updateFields();
  }
}
