package csbase.client.applications.statsviewer.graphic;

import java.util.Observable;

import csbase.client.applications.statsviewer.LogsView;
import csbase.client.applications.statsviewer.StatsViewer;

/**
 * Painel que exibe o grfico com as execues por ALGORITMOS realizadas no
 * tempo (desconsiderando as realizadas pelo usurio admin).
 */
public class AlgorithmsDatePanel extends GraphicPanel {

  /**
   * Construtor.
   *
   * @param app referncia para a aplicao que iniciou o painel
   * @param title ttulo do grfico
   */
  public AlgorithmsDatePanel(StatsViewer app, String title) {
    super(app, title);
    newBarChart3DPanel(app.getString("date"), app
      .getString("executions.number"), true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void update(Observable appObservable, Object view) {
    LogsView infoView = (LogsView) view;
    updateSubTitle(infoView.getInfo());
    updateMapDataSet(infoView.getAlgorithmsByDate());
  }

}
