package csbase.client.applications.statsviewer.graphic;

import java.util.Observable;

import csbase.client.applications.statsviewer.LogsView;
import csbase.client.applications.statsviewer.StatsViewer;

/**
 * Painel que exibe o grfico com o Nmero de Utilizaes das Aplicaes no
 * tempo (desconsiderando as aplicaes abertas pelo usurio admin).
 */
public class ApplicationsDatePanel extends GraphicPanel {

  /**
   * Construtor do painel ApplicationDatePanel.
   *
   * @param app referncia para a aplicao que iniciou o painel
   * @param title ttulo do grfico
   */
  public ApplicationsDatePanel(StatsViewer app, String title) {
    super(app, title);
    newBarChart3DPanel(app.getString("date"), app
      .getString("applications.number"), true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void update(Observable appObservable, Object view) {
    LogsView infoView = (LogsView) view;
    updateSubTitle(infoView.getInfo());
    updateMapDataSet(infoView.getApplicationsMap());
  }

}
