/*
 * ProjectTreeListener.java
 * $Author: isabella $
 * $Revision: 142631 $  - $Date: 2013-07-15 15:21:13 -0300 (Mon, 15 Jul 2013) $
 */
package csbase.client.project;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;

/**
 * A interface <code>ProjectTreeListener</code> modela um listener com mtodos
 * de callback chamados para eventos ocorridos sobre a rvore de projetos.
 */
public interface ProjectTreeListener {
  /**
   * Mtodo chamado quando alguma informao do projeto mudou.
   */
  public void projectInfoModified();

  /**
   * Mtodo chamado quando o projeto exibido na rvore foi trocado.
   * 
   * @param project novo projeto a ser exibido
   */
  public void projectChanged(CommonClientProject project);

  /**
   * Mtodo chamado quando o projeto foi fechado.
   * 
   * @param project projeto fechado.
   */
  public void projectClosed(CommonClientProject project);

  /**
   * Mtodo chamado quando o projeto foi removido.
   */
  public void projectRemoved();

  /**
   * Mtodo chamado quando o menu popup de diretrio  acionado.
   * 
   * @param dir diretrio selecionado
   */
  public void popupDirTriggered(ClientProjectFile dir);

  /**
   * Mtodo chamado quando o menu popup de arquivo  acionado.
   * 
   * @param file arquivo selecionado
   */
  public void popupFileTriggered(ClientProjectFile file);

  /**
   * Mtodo chamado quando o menu popup de seleo mltipla  acionada.
   */
  public void popupMultSelectionTriggered();

  /**
   * Mtodo chamado quando o menu popup da raiz  acionado.
   */
  public void popupRootTriggered();
}
