/*
 * $Id:$
 */
package csbase.client.project.tasks;

import java.awt.Window;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;

/**
 * Task para troca de tipo de arquivo.
 * 
 * @author Tecgraf
 */
public class ChangeFileTypeTask extends CoreTask<Void> {

  /**
   * Arquivo a ser modificado.
   */
  final private ClientProjectFile file;
  /**
   * O novo tipo.
   */
  final private ProjectFileType newType;

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    if (newType.equals(file.getType())) {
      return;
    }
    file.changeType(newType.getCode());
  }

  /**
   * Construtor.
   * 
   * @param file o arquivo.
   * @param newType o novo tipo.
   */
  public ChangeFileTypeTask(ClientProjectFile file,
    final ProjectFileType newType) {
    if (file == null) {
      throw new IllegalArgumentException("null file not allowed!");
    }
    final ProjectFileType unknown = ProjectFileType.getUnknownFileType();

    this.file = file;
    this.newType = (newType == null ? unknown : newType);
  }

  /**
   * Mtodo de convenincia para chamada automtica da task.
   * 
   * @param window janela-me para a task.
   * @param file arquivo.
   * @param fileType tipo do arquivo.
   * 
   * @return o arquivo ou null
   */
  static final public boolean runTask(Window window, ClientProjectFile file,
    ProjectFileType fileType) {
    final ChangeFileTypeTask task = new ChangeFileTypeTask(file, fileType);
    final String path = file.getStringPath();
    final Object[] args = new Object[] { path, fileType };
    final boolean executed = task.execute(window, args);
    return executed;
  }
}
