/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.statsviewer;

import csbase.client.applications.statsviewer.LogsView;
import csbase.client.applications.statsviewer.StatsViewer;
import csbase.client.applications.statsviewer.graphic.AlgorithmsDatePanel;
import csbase.client.applications.statsviewer.graphic.ApplicationsDatePanel;
import csbase.client.applications.statsviewer.graphic.ExecutionsAlgorithmPanel;
import csbase.client.applications.statsviewer.graphic.ExecutionsDatePanel;
import csbase.client.applications.statsviewer.graphic.ExecutionsUsersPanel;
import csbase.client.applications.statsviewer.graphic.GraphicPanel;
import csbase.client.applications.statsviewer.graphic.LoginsDatePanel;
import csbase.client.applications.statsviewer.graphic.LoginsUsersPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import tecgraf.javautils.gui.GBC;

public class GraphicTabsPanel
extends JPanel {
    private StatsViewer appViewer;
    private JPanel cardsPanel;

    public GraphicTabsPanel(StatsViewer appViewer) {
        super(new GridBagLayout());
        this.appViewer = appViewer;
        GBC gbc = new GBC(0, 0).northwest().insets(5).both();
        this.add((Component)this.buildCardsPanel(), gbc);
    }

    private JPanel buildCardsPanel() {
        this.cardsPanel = new JPanel(new CardLayout());
        JTabbedPane loginTabbedPane = new JTabbedPane();
        String title = this.appViewer.getString("login.date.title");
        String tabtitle = this.appViewer.getString("login.date.tab");
        GraphicPanel graphicPanel = new LoginsDatePanel(this.appViewer, title);
        loginTabbedPane.addTab(tabtitle, graphicPanel);
        title = this.appViewer.getString("login.users.title");
        tabtitle = this.appViewer.getString("login.users.tab");
        graphicPanel = new LoginsUsersPanel(this.appViewer, title);
        loginTabbedPane.addTab(tabtitle, graphicPanel);
        JTabbedPane applicationsTabbedPane = new JTabbedPane();
        title = this.appViewer.getString("applications.date.title");
        tabtitle = this.appViewer.getString("applications.date.tab");
        graphicPanel = new ApplicationsDatePanel(this.appViewer, title);
        applicationsTabbedPane.addTab(tabtitle, graphicPanel);
        JTabbedPane executionsTabbedPane = new JTabbedPane();
        title = this.appViewer.getString("executions.users.title");
        tabtitle = this.appViewer.getString("executions.users.tab");
        graphicPanel = new ExecutionsUsersPanel(this.appViewer, title);
        executionsTabbedPane.addTab(tabtitle, graphicPanel);
        title = this.appViewer.getString("executions.algorithm.title");
        tabtitle = this.appViewer.getString("executions.algorithm.tab");
        graphicPanel = new ExecutionsAlgorithmPanel(this.appViewer, title);
        executionsTabbedPane.addTab(tabtitle, graphicPanel);
        title = this.appViewer.getString("algorithms.date.title");
        tabtitle = this.appViewer.getString("algorithms.date.tab");
        graphicPanel = new AlgorithmsDatePanel(this.appViewer, title);
        executionsTabbedPane.addTab(tabtitle, graphicPanel);
        title = this.appViewer.getString("executions.date.title");
        tabtitle = this.appViewer.getString("executions.date.tab");
        graphicPanel = new ExecutionsDatePanel(this.appViewer, title);
        executionsTabbedPane.addTab(tabtitle, graphicPanel);
        this.cardsPanel.add((Component)loginTabbedPane, LogsView.LogsDataType.LoginData.name());
        this.cardsPanel.add((Component)applicationsTabbedPane, LogsView.LogsDataType.ApplicationsData.name());
        this.cardsPanel.add((Component)executionsTabbedPane, LogsView.LogsDataType.ExecutionsData.name());
        return this.cardsPanel;
    }

    public void setLogType(LogsView.LogsDataType selectedType) {
        CardLayout cl = (CardLayout)this.cardsPanel.getLayout();
        cl.show(this.cardsPanel, selectedType.name());
    }
}

