/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.util;

import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.editors.FavoriteApplicationsEditor;
import csbase.client.preferences.editors.LocalDirectoryEditor;
import csbase.client.preferences.editors.PreferredAppEditor;
import csbase.client.preferences.types.PVBoolean;
import csbase.client.preferences.types.PVColor;
import csbase.client.preferences.types.PVInteger;
import csbase.client.preferences.types.PVTables;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public class PreferencesUtil {
    static Font font = new Font("SansSerif", 0, 13);

    public static JPanel createPreferencePanel(PreferenceCategory pc, boolean showDefaultValues) {
        JPanel preferencePanel = new JPanel(new GridBagLayout());
        if (pc.hasPreferences(PreferencePolicy.READ_ONLY, PreferencePolicy.READ_WRITE)) {
            int row = 0;
            for (JComponent component : PreferencesUtil.createComponentList(pc, showDefaultValues)) {
                preferencePanel.add((Component)component, new GBC(0, row++).horizontal().left(10).right(10));
            }
            preferencePanel.add((Component)new JLabel(), new GBC(0, row).both());
        } else {
            JLabel label = new JLabel(LNG.get((String)"no.preferences"));
            label.setFont(font);
            preferencePanel.add((Component)label, new GBC(0, 0).insets(10));
            preferencePanel.add((Component)new JLabel(), new GBC(0, 1).both());
        }
        return preferencePanel;
    }

    public static String getAppEnumName(ApplicationRegistry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Registro de aplica\u00e7\u00e3o n\u00e3o pode ser nulo.");
        }
        return registry.getClassName() + "Pref";
    }

    public static PreferenceCategory deepSearch(PreferenceDefinition name, PreferenceCategory base) {
        PreferenceCategory result = base;
        Stack stack = new Stack();
        Class<?> currentCat = name.getClass();
        while (PreferencesUtil.isPreferenceDefition(currentCat) && !base.getId().equals(currentCat.getName())) {
            stack.push(currentCat);
            currentCat = currentCat.getEnclosingClass();
        }
        while (!stack.empty()) {
            result = result.getCategory((Class)stack.pop());
        }
        return result;
    }

    private static List<JComponent> createComponentList(PreferenceCategory pc, boolean showDefaultValues) {
        ArrayList fold = new ArrayList();
        PreferenceValue<?> lastValue = null;
        LinkedList lastList = null;
        for (PreferenceValue<?> pv : pc.getPreferences(PreferencePolicy.READ_ONLY, PreferencePolicy.READ_WRITE)) {
            if (PreferencesUtil.isChanged(pv, lastValue)) {
                lastList = new LinkedList();
                fold.add(lastList);
            }
            lastList.add(pv);
            lastValue = pv;
        }
        LinkedList<JComponent> result = new LinkedList<JComponent>();
        for (List list : fold) {
            JPanel panel = new JPanel(new GridBagLayout());
            int row = 0;
            for (PreferenceValue pv : list) {
                JLabel label = new JLabel(pv.getLabel());
                label.setToolTipText(pv.getDescription());
                label.setFont(font);
                JComponent component = null;
                if (pv.getEditor() != null) {
                    PreferenceEditor editor = pv.getEditor();
                    component = editor.getComponent(showDefaultValues);
                } else {
                    component = new JLabel();
                }
                if (pv instanceof PVBoolean && component instanceof JCheckBox) {
                    JCheckBox check = (JCheckBox)component;
                    check.setText(label.getText());
                    check.setToolTipText(label.getToolTipText());
                    check.setFont(font);
                    panel.add((Component)component, new GBC(0, row++).west().insets(3).horizontal());
                    continue;
                }
                if (pv instanceof PVBoolean || pv instanceof PVColor) {
                    panel.add((Component)component, new GBC(0, row).west().none().insets(3));
                    panel.add((Component)label, new GBC(1, row++).east().horizontal().insets(3));
                    continue;
                }
                if (pv instanceof PVInteger) {
                    panel.add((Component)label, new GBC(0, row).west().none().insets(3));
                    panel.add((Component)component, new GBC(1, row).west().insets(3));
                    panel.add((Component)new JLabel(), new GBC(2, row++).horizontal().insets(3));
                    continue;
                }
                if (pv instanceof PVTables || pv.getEditor() instanceof PreferredAppEditor || pv.getEditor() instanceof LocalDirectoryEditor || pv.getEditor() instanceof FavoriteApplicationsEditor) {
                    panel.add((Component)component, new GBC(0, row++).west().horizontal().insets(3));
                    continue;
                }
                panel.add((Component)label, new GBC(0, row).west().none().insets(3));
                panel.add((Component)component, new GBC(1, row++).horizontal().insets(3));
            }
            result.add(panel);
        }
        return result;
    }

    private static boolean isChanged(PreferenceValue<?> pv, PreferenceValue<?> lastValue) {
        if (lastValue == null) {
            return true;
        }
        if (!lastValue.getClass().equals(pv.getClass()) && (lastValue instanceof PVBoolean || pv instanceof PVBoolean)) {
            return true;
        }
        return !lastValue.getClass().equals(pv.getClass()) && (lastValue instanceof PVColor || pv instanceof PVColor);
    }

    private static boolean isPreferenceDefition(Class<?> clazz) {
        Class<?>[] interfaces;
        if (clazz == null) {
            return false;
        }
        for (Class<?> impl : interfaces = clazz.getInterfaces()) {
            if (!impl.equals(PreferenceDefinition.class)) continue;
            return true;
        }
        return false;
    }
}

