/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import csbase.client.desktop.DesktopFrame;
import csbase.client.remote.srvproxies.MailProxy;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.Version;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;

public final class ExceptionMessenger {
    private static ExceptionMessenger instance;

    private ExceptionMessenger() {
    }

    public static ExceptionMessenger getInstance() {
        if (instance == null) {
            instance = new ExceptionMessenger();
        }
        return instance;
    }

    public boolean send(Throwable throwable) {
        return this.send(throwable, null, null);
    }

    public boolean send(Throwable throwable, String comment) {
        return this.send(throwable, comment, null);
    }

    public boolean send(Throwable throwable, String comment, String[] additionalInfo) {
        String messageBody = this.getMessageBody(throwable, comment, additionalInfo);
        return MailProxy.mailSupport(messageBody);
    }

    private static String getExceptionText(Throwable throwable) {
        Throwable curr;
        String separator = "";
        String tab = "";
        String text = "";
        Throwable prox = throwable;
        do {
            curr = prox;
            text = text + separator;
            text = text + tab + "Classe: " + curr.getClass().getName() + "\n";
            text = text + tab + "Mensagem: " + curr.getLocalizedMessage() + "\n";
            text = text + tab + "Pilha:\n";
            StackTraceElement[] stackTrace = curr.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                text = text + tab + stackTrace[i] + "\n";
            }
            separator = "\nCausada pela exce\u00e7\u00e3o:\n";
            tab = tab + "  ";
            if (curr instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)curr;
                prox = ite.getTargetException();
                continue;
            }
            prox = curr.getCause();
        } while (prox != null && curr != prox);
        return text;
    }

    private String getMessageBody(Throwable throwable, String comment, String[] additionalInfo) {
        Version version;
        StringBuilder text = new StringBuilder();
        User user = User.getLoggedUser();
        text.append("Nome do usu\u00e1rio: ").append(user.getName());
        text.append(" (").append(user.getLogin()).append(")");
        text.append("\nE-mails do usu\u00e1rio: ");
        String[] emails = user.getEmails();
        if (emails == null || emails.length == 0) {
            text.append("-");
        } else {
            for (String email : emails) {
                text.append("\n\t" + email);
            }
        }
        text.append("\nData: ");
        text.append(FormatUtils.format((Date)new Date(), (int)3));
        if (DesktopFrame.getInstance() != null) {
            CommonClientProject project = DesktopFrame.getInstance().getProject();
            if (project == null) {
                text.append("\n").append(LNG.get((String)"UTIL_ADDITIONAL_INFO_NO_PROJECT"));
            } else {
                text.append("\n").append(LNG.get((String)"UTIL_ADDITIONAL_INFO_PROJECT"));
                text.append(" ").append(project.getName());
            }
        }
        if ((version = Version.getInstance()) != null) {
            text.append("\n").append(LNG.get((String)"UTIL_ADDITIONAL_INFO_VERSION"));
            text.append(" ").append(version.getVersion());
        }
        if (additionalInfo != null && additionalInfo.length > 0) {
            text.append("\nInforma\u00e7\u00f5es do problema:");
            for (int i = 0; i < additionalInfo.length; ++i) {
                text.append("\n -> ").append(additionalInfo[i]);
            }
        }
        if (comment != null) {
            text.append("\nComent\u00e1rio: ").append(comment);
        }
        text.append("\nExce\u00e7\u00e3o: ").append(ExceptionMessenger.getExceptionText(throwable));
        return text.toString();
    }
}

