/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.Validator;

public final class DoubleValidator
implements Validator {
    private boolean includeMinimum;
    private boolean includeMaximum;
    private Double maximum;
    private Double minimum;

    public DoubleValidator(Double minimum, boolean includeMinimum, Double maximum, boolean includeMaximum) {
        if (maximum == null) {
            maximum = Double.MAX_VALUE;
        }
        if (minimum == null) {
            minimum = Double.MIN_VALUE;
        }
        if (maximum.compareTo(minimum) < 0) {
            throw new IllegalArgumentException(String.format("O m\u00e1ximo %f \u00e9 menor do que o m\u00ednimo %f.", maximum, minimum));
        }
        if (!includeMaximum && !includeMinimum && maximum.equals(minimum)) {
            throw new IllegalArgumentException(String.format("O m\u00e1ximo n\u00e3o pode ser igual ao m\u00ednimo (%f), pois \u00e9 o valor m\u00e1ximo e/ou m\u00ednimo n\u00e3o fazem parte do intervalo v\u00e1lido.", minimum));
        }
        this.minimum = minimum;
        this.includeMinimum = includeMinimum;
        this.maximum = maximum;
        this.includeMaximum = includeMaximum;
    }

    public DoubleValidator(Double minimum, Double maximum) {
        this(minimum, true, maximum, true);
    }

    @Override
    public String getValidationErrorMessage(Object value) {
        Double doubleValue = (Double)value;
        if (doubleValue == null) {
            return null;
        }
        if (this.includeMinimum) {
            if (doubleValue.compareTo(this.minimum) < 0) {
                return String.format("Valor abaixo do m\u00ednimo (%f).", this.minimum);
            }
        } else if (doubleValue.compareTo(this.minimum) <= 0) {
            return String.format("O valor informado deveria ser menor do que %f.", this.minimum);
        }
        if (this.includeMaximum) {
            if (doubleValue.compareTo(this.maximum) > 0) {
                return String.format("Valor acima do m\u00e1ximo (%f).", this.maximum);
            }
        } else if (doubleValue.compareTo(this.maximum) >= 0) {
            return String.format("O valor informado deveria ser menor do que %f.", this.maximum);
        }
        return null;
    }
}

