package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.TextParameter;

/**
 * <p>
 * Analisador de {@link TextParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo texto. O elemento corrente
 * do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link TextParameter}.
 * </p>
 */
public class TextParameterFactory extends
  AbstractTextParameterParser<TextParameter> {

  /**
   * <p>
   * O elemento {@value #TEXT_PARAMETER_ELEMENT}: descreve as propriedades de um
   * {@link TextParameter parmetro do tipo texto}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  static final String TEXT_PARAMETER_ELEMENT = "texto";

  /**
   * {@inheritDoc}
   */
  @Override
  protected TextParameter createTextParameter(XmlParser parser, String name,
    String label, String description, boolean isOptional, boolean isVisible,
    String commandLinePattern, Integer maxCharacters) throws ParseException {
    String defaultValue =
      parser.extractAttributeValue(PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE,
        null);
    return new TextParameter(name, label, description, defaultValue,
      isOptional, isVisible, commandLinePattern, maxCharacters);
  }

}
