/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.administration.AdministrationDeleteException;
import csbase.logic.AdministrationEvent;
import csbase.logic.IdInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public abstract class Permission
implements Serializable,
Comparable<Object>,
IdInterface {
    private Object id;
    protected String name;
    protected String description;
    private static Hashtable<Object, Permission> permissions = new Hashtable();
    private static boolean hasAllPermissions = false;
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    protected Permission() {
    }

    protected Permission(String name, String description) {
        this.name = name != null ? name : "";
        this.description = description != null ? description : "";
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static List<String> getPermissionClasses() throws Exception {
        return ClientRemoteLocator.administrationService.getPermissionClasses();
    }

    @Override
    public int compareTo(Object obj) {
        return this.name.compareTo(((Permission)obj).name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission p = (Permission)obj;
        return p.getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equalContents(Object obj) {
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission p = (Permission)obj;
        return p.getId().equals(this.id) && p.getName().equals(this.name) && p.getDescription().equals(this.description);
    }

    public static List<Permission> getAllPermissions() throws Exception {
        if (hasAllPermissions) {
            return Permission.permissionsToVector();
        }
        List<Permission> allPermissions = ClientRemoteLocator.administrationService.getAllPermissions();
        for (Permission permission : allPermissions) {
            if (permissions.containsKey(permission.getId())) continue;
            permissions.put(permission.getId(), permission);
        }
        hasAllPermissions = true;
        return allPermissions;
    }

    public static Permission getPermission(Object id) throws RemoteException {
        if (id == null) {
            return null;
        }
        Permission permission = permissions.get(id);
        if (permission == null && !hasAllPermissions && (permission = ClientRemoteLocator.administrationService.getPermission(id)) != null) {
            permissions.put(id, permission);
        }
        return permission;
    }

    public static Permission createPermission(Permission permission) throws Exception {
        if (permission == null) {
            throw new Exception("Permission.createPermission: permission est\u00e1 vazia");
        }
        if (Permission.getPermissionByName(permission.getName()) != null) {
            return null;
        }
        Permission result = ClientRemoteLocator.administrationService.createPermission(permission);
        if (result != null) {
            permissions.put(result.getId(), result);
        }
        return result;
    }

    public static Permission getPermissionByName(String name) throws Exception {
        List<Permission> allPermissions = Permission.getAllPermissions();
        for (Permission permission : allPermissions) {
            if (!permission.getName().equalsIgnoreCase(name)) continue;
            return permission;
        }
        return null;
    }

    public static Permission modifyPermission(Object id, Permission permission) throws Exception {
        Permission oldPermission = Permission.getPermission(id);
        if (oldPermission == null) {
            return null;
        }
        if (!oldPermission.getName().equals(permission.getName()) && Permission.existsAnotherPermission(id, permission.getName())) {
            return null;
        }
        Permission result = ClientRemoteLocator.administrationService.modifyPermission(id, permission);
        permissions.put(id, result);
        return result;
    }

    public static boolean existsAnotherPermission(Object id, String name) throws Exception {
        Permission anotherPermission = Permission.getPermissionByName(name);
        return anotherPermission != null && !anotherPermission.getId().equals(id);
    }

    public static void deletePermission(Object id) throws Exception, AdministrationDeleteException {
        ClientRemoteLocator.administrationService.deletePermission(id);
        permissions.remove(id);
    }

    private static Vector<Permission> permissionsToVector() {
        Vector<Permission> allPermissions = new Vector<Permission>();
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            allPermissions.add(e.nextElement());
        }
        return allPermissions;
    }

    public static void addObserver(Observer obs) {
        if (observable != null) {
            observable.addObserver(obs);
        }
    }

    public static void deleteObserver(Observer obs) {
        if (observable != null) {
            observable.deleteObserver(obs);
        }
    }

    public static void update(AdministrationEvent event) {
        Permission permission = (Permission)event.item;
        Object id = permission.getId();
        switch (event.type) {
            case 1: 
            case 2: {
                permissions.put(id, permission);
                break;
            }
            case 3: {
                permissions.remove(id);
            }
        }
        observable.notifyObservers(event);
    }

    public String toString() {
        return "[" + this.id + "," + this.name + "," + this.description + "]";
    }

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                hasAllPermissions = false;
                permissions = new Hashtable();
                observable.deleteObservers();
            }
        });
    }
}

