/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import java.io.Serializable;
import tecgraf.javautils.core.io.FileUtils;

public final class FileParameterValue
implements Comparable<FileParameterValue>,
Serializable,
Cloneable {
    private static final String FILE_SEPARATOR = "/";
    private String path;
    private String type;

    public FileParameterValue(String path) {
        this(path, "UNKNOWN");
    }

    public FileParameterValue(String path, String type) {
        this.setPath(path);
        this.setType(type);
    }

    @Override
    public int compareTo(FileParameterValue file) {
        return this.getPath().compareToIgnoreCase(file.getPath());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        FileParameterValue file = (FileParameterValue)obj;
        if (!this.getPath().equals(file.getPath())) {
            return false;
        }
        return this.getType().equals(file.getType());
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(char fileSeparator) {
        return this.path.replace(FILE_SEPARATOR, String.valueOf(fileSeparator));
    }

    public String[] getPathAsArray() {
        return FileUtils.splitPath((String)this.path, (String)FILE_SEPARATOR);
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean isDirectory() {
        return this.getType().equals("DIRECTORY_TYPE");
    }

    public boolean isRegularFile() {
        return !this.isDirectory();
    }

    public boolean isTypeKnown() {
        return this.getType().equals("UNKNOWN");
    }

    public void setPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("O par\u00e2metro path est\u00e1 nulo.");
        }
        String auxPath = path.length() == 0 ? "." : path.replaceAll("\\\\", FILE_SEPARATOR);
        this.path = auxPath;
    }

    public String toString() {
        if (this.path.equals(".")) {
            return FILE_SEPARATOR;
        }
        return FILE_SEPARATOR + this.path;
    }

    private void setType(String newType) {
        String auxType = newType;
        if (newType == null || newType.trim().isEmpty()) {
            auxType = "UNKNOWN";
        }
        this.type = auxType;
    }

    public FileParameterValue clone() {
        return new FileParameterValue(this.path, this.type);
    }
}

