/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileListParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.FileParameterValidator;
import csbase.logic.algorithms.parameters.validators.ListParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import java.util.List;

public final class FileListParameterValidator
extends ListParameterValidator<FileParameterValue> {
    public FileListParameterValidator(FileParameterValidator fileValidator) {
        super(fileValidator);
    }

    @Override
    public final Validation validateValue(SimpleParameter<?> parameter, List<FileParameterValue> values, ValidationContext context) throws RemoteException {
        if (!parameter.isVisible() || !parameter.isEnabled()) {
            return new ValidationSuccess();
        }
        if (values == null || values.isEmpty()) {
            if (this.isOptional() || this.getMode().equals((Object)ValidationMode.ALLOW_EMPY_VALUES)) {
                return new ValidationSuccess();
            }
            LocalizedMessage message = new LocalizedMessage(ListParameterValidator.class, "empty_value", new Object[]{parameter.getLabel()});
            return new ValidationError(message);
        }
        FileListParameter fileListParameter = (FileListParameter)parameter;
        for (FileParameterValue file : values) {
            FileParameterValidator validator = this.getItemValidator();
            Validation result = validator.validateFile(file, fileListParameter.getMode(), context.getProjectId(), fileListParameter.mustExist());
            if (result.isWellSucceded()) continue;
            return result;
        }
        return new ValidationSuccess();
    }

    public FileParameterValidator getItemValidator() {
        return (FileParameterValidator)super.getItemValidator();
    }
}

