/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.ArrayList;

class InputFileListParameterParser
extends AbstractFileParameterParser<InputFileListParameter> {
    InputFileListParameterParser() {
    }

    @Override
    public InputFileListParameter createFileParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, String type) throws ParseException {
        FileParameterPipeAcceptance usesPipe;
        boolean pipeDefined = parser.hasAttributeValue("permitir_pipe");
        if (pipeDefined && ((usesPipe = parser.extractAttributeValueAsEnumeration("permitir_pipe", new AbstractFileParameterParser.FileParameterPipeAcceptanceConverter(this))) == FileParameterPipeAcceptance.TRUE || usesPipe == FileParameterPipeAcceptance.ALWAYS)) {
            throw new ParseException("Arquivo de entrada (sele\u00e7\u00e3o m\u00faltipla) n\u00e3o admite pipes");
        }
        String modeName = parser.extractAttributeValue("categoria", "arquivo");
        FileParameterMode mode = null;
        if (modeName.equals("diretorio")) {
            mode = FileParameterMode.DIRECTORY;
        } else if (modeName.equals("ambos")) {
            mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
        } else if (modeName.equals("arquivo")) {
            mode = FileParameterMode.REGULAR_FILE;
        } else {
            throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 v\u00e1lida.\nCategorias v\u00e1lidas:\n{1};\n{2};{3}.", modeName, "arquivo", "diretorio", "ambos");
        }
        boolean useRootDirectoryAsDefault = parser.extractAttributeValueAsBoolean("usar_diretorio_raiz_como_padrao", false);
        ArrayList<FileParameterValue> defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException("O atributo {0} \u00e9 inv\u00e1lido quando o par\u00e2metro de entrada \u00e9 um arquivo.", "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new ArrayList<FileParameterValue>();
            defaultValue.add(new FileParameterValue("."));
        }
        boolean mustSort = parser.extractAttributeValueAsBoolean("ordenar", true);
        boolean useFilter = parser.extractAttributeValueAsBoolean("usar_filtro", false);
        InputFileListParameter parameter = new InputFileListParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, type, mode, mustSort, useFilter);
        return parameter;
    }
}

