/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.xml.algorithmspack;

import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.xml.algorithmspack.XMLVersionElement;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLBasicElement;
import tecgraf.javautils.xml.XMLElementInterface;

public class XMLVersionSetElement
extends XMLBasicElement {
    private Hashtable<AlgorithmVersionId, AlgorithmVersionInfo> versions;

    public Hashtable<AlgorithmVersionId, AlgorithmVersionInfo> getVersions() {
        return this.versions;
    }

    public XMLVersionSetElement() {
        this.setTag("versoes");
        this.versions = new Hashtable();
    }

    public void endTag(List<XMLElementInterface> childrenList) {
        int major = 0;
        int minor = 0;
        int patch = 0;
        AlgorithmVersionId versionId = null;
        AlgorithmVersionInfo versionInfo = null;
        ImprovedXMLListIterator iterator = new ImprovedXMLListIterator(childrenList);
        while (iterator.hasNext()) {
            XMLElementInterface nextElem = iterator.next();
            if (!this.isVersionElement(nextElem)) continue;
            major = this.getPropertyMajor(nextElem);
            minor = this.getPropertyMinor(nextElem);
            patch = this.getPropertyPatch(nextElem);
            if (major == -1 || minor == -1 || patch == -1) continue;
            versionId = new AlgorithmVersionId(major, minor, patch);
            String versionDesc = ((XMLVersionElement)nextElem).getDescription();
            Map<String, String> versionProps = ((XMLVersionElement)nextElem).getProperties();
            versionInfo = this.createVersionInfo(versionId, versionDesc, versionProps);
            this.versions.put(versionId, versionInfo);
        }
    }

    private AlgorithmVersionInfo createVersionInfo(AlgorithmVersionId id, String description, Map<String, String> propertyValues) {
        return new AlgorithmVersionInfo(id, description, propertyValues);
    }

    private boolean isVersionElement(XMLElementInterface xmlElem) {
        return xmlElem.getTag().equals("versao");
    }

    private int getPropertyPatch(XMLElementInterface xmlElem) {
        String patchStrValue = xmlElem.getAttributeStrValue("patch");
        return Integer.parseInt(patchStrValue);
    }

    private int getPropertyMinor(XMLElementInterface xmlElem) {
        String minorStrValue = xmlElem.getAttributeStrValue("minor");
        return Integer.parseInt(minorStrValue);
    }

    private int getPropertyMajor(XMLElementInterface xmlElem) {
        String majorStrValue = xmlElem.getAttributeStrValue("major");
        return Integer.parseInt(majorStrValue);
    }

    public void write(Writer arg0, String arg1) throws IOException {
    }

    public Hashtable<AlgorithmVersionId, AlgorithmVersionInfo> getVersionsValues() {
        return this.versions;
    }
}

