/*
 * $Id: CloseProjectNotification.java 157822 2014-10-30 13:25:28Z pietroguedes $
 */
package csbase.logic;

/**
 * Notificao de fechamento de projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CloseProjectNotification extends Notification {

  /**
   * Nome do projeto.
   */
  private String projectName;

  /**
   * Construtor.
   * 
   * @param sender remetente
   * @param projectName nome do projeto.
   */
  public CloseProjectNotification(String sender, String projectName) {
    super(sender);
    this.projectName = projectName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return ("Notificao de fechamento do projeto " + projectName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isVolatile() {
    return false;
  }

  /**
   * Consulta nome do projeto.
   * 
   * @return nome
   */
  public String getProjectName() {
    return this.projectName;
  }
}
