/*
 * PlatformInfo.java
 *
 * $Author: brunoos $
 * $Revision: 34611 $  - $Date: 2004-10-19 07:40:53 -0300 (Tue, 19 Oct 2004) $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * A classe <code>PlatformInfo</code> contm informaes de uma plataforma de
 * execuo (Platform).
 *
 * @author Marcos Machado
 * @version
 */
public class PlatformInfo implements Serializable, Cloneable {
  /**
   * Nome da plataforma. O nome de uma plataforma indica o sistema operacional
   * e verso do mesmo. Exemplo: IRIX65
   */
  public String name;

  /** Descrio da plataforma */
  public String description;

  public Object clone() {
    try {
      return super.clone();
    }
    catch (CloneNotSupportedException e) {
      return null;
    }
  }

  public boolean equals(Object obj) {
    if (!(obj instanceof PlatformInfo)) {
      return false;
    }
    PlatformInfo info = (PlatformInfo)obj;
    return name.equals(info.name) && description.equals(info.description);
  }

  /**
   * Calcula o cdigo hash do objeto.
   *
   * @return Inteiro que representa o cdigo hash do objeto.
   */
  public int hashCode() {
     return (name + description).hashCode();
  }


  /**
   * Cria um PlatformInfo.
   *
   * @param name .
   * @param description .
   */
  public PlatformInfo(String name, String description) {
    this.name = (name!=null ? name : "");
    this.description = (description!=null ? description : "");
  }
}
