package csbase.logic.algorithms.parameters;

import java.util.List;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;

/**
 * Mtodo que determina o menor valor de uma tabela.
 */
public final class TableMinExpressionFunction extends TableExpressionFunction {

  /**
   * Construtor.
   */
  public TableMinExpressionFunction() {
    super("table_min", new Class[] {});
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Object doOperation(List<Object> values, Object... arguments)
    throws ExpressionFunctionExecutionException {
    if (values == null) {
      throw new ExpressionFunctionExecutionException("A tabela est vazia.");
    }
    double minValue = Double.MAX_VALUE;
    for (Object value : values) {
      double doubleValue = Double.parseDouble(value.toString());
      if (doubleValue < minValue) {
        minValue = doubleValue;
      }
    }
    return minValue;
  }
}
