package csbase.logic.algorithms.parameters.validators;

import java.rmi.RemoteException;

import csbase.logic.algorithms.parameters.FormulaParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationSuccess;

/**
 * <p>
 * Valida textos de usurio que so valores para parmetros da classe
 * {@link FormulaParameter}.
 * </p>
 * 
 * <p>
 * Veja {@link FormulaParameter} para saber o que  um texto vlido.
 * </p>
 * 
 * @author lmoreira
 */
public final class FormulaParameterValidator extends
  SimpleParameterValidator<String> {

  /**
   * Cria o validador.
   * 
   * @param isOptional Indica se o parmetro  opcional (aceita {@code null}
   *        como valor) ou  obrigatrio (no aceita {@code null} como valor).
   */
  public FormulaParameterValidator(boolean isOptional) {
    super(isOptional);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Validation validateValue(SimpleParameter<?> parameter, String value,
    ValidationContext context) throws RemoteException {

    Validation result = super.validateValue(parameter, value, context);
    if (!result.isWellSucceded()) {
      return result;
    }

    FormulaParameter formulaParameter = (FormulaParameter) parameter;
    String commandValue = formulaParameter.getEncodedValue(value);
    if (commandValue != null) {
      if (!commandValue.matches("[A-Za-z0-9_]+")) {
        LocalizedMessage message =
          new LocalizedMessage(FormulaParameterValidator.class, "message",
            new Object[] { parameter.getName(), value });
        return new ValidationError(message);
      }
    }
    return new ValidationSuccess();
  }
}
