package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;

/**
 * <p>
 * Carrega um {@link IntegerParameter}.
 * </p>
 * 
 * <p>
 * O elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link IntegerParameter}.
 * </p>
 * 
 */
public class IntegerParameterFactory extends
  AbstractIntegerParameterParser<IntegerParameter> {

  /**
   * <p>
   * O elemento {@value #INTEGER_PARAMETER_ELEMENT}: descreve as propriedades de
   * um {@link IntegerParameter parmetro do tipo inteiro}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  static final String INTEGER_PARAMETER_ELEMENT = "inteiro";

  /**
   * {@inheritDoc}
   */
  @Override
  protected IntegerParameter createIntegerParameter(XmlParser parser,
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, Integer maximum,
    Integer minimum) throws ParseException {
    Integer defaultValue =
      parser.extractAttributeValueAsInteger(
        PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null, maximum, minimum);
    IntegerParameter parameter =
      new IntegerParameter(name, label, description, defaultValue, isOptional,
        isVisible, commandLinePattern, maximum, minimum);
    return parameter;
  }

}
